/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySystemExit;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedEvalUnitImpl
implements EmbedEvalUnit {
    private ScriptingContainer container;
    private Node node;
    private ManyVarsDynamicScope scope;
    private Script script;

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope) {
        this(container, node, scope, null);
    }

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope, Script script) {
        this.container = container;
        this.node = node;
        this.scope = scope;
        this.script = script;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public ManyVarsDynamicScope getScope() {
        return this.scope;
    }

    @Override
    public IRubyObject run() {
        if (this.node == null && this.script == null) {
            return null;
        }
        Ruby runtime = this.container.getProvider().getRuntime();
        BiVariableMap vars = this.container.getVarMap();
        boolean sharing_variables = true;
        Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
        if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            sharing_variables = false;
        }
        ThreadContext threadContext = runtime.getCurrentContext();
        try {
            RubyInstanceConfig.CompileMode mode2;
            if (sharing_variables) {
                vars.inject(this.scope, 0, null);
                threadContext.pushScope(this.scope);
            }
            IRubyObject ret = (mode2 = runtime.getInstanceConfig().getCompileMode()) == RubyInstanceConfig.CompileMode.FORCE ? runtime.runScriptBody(this.script) : runtime.runInterpreter(this.node);
            if (sharing_variables) {
                vars.retrieve(ret);
            }
            IRubyObject iRubyObject = ret;
            return iRubyObject;
        }
        catch (RaiseException e) {
            if (e.getException() instanceof RubySystemExit) {
                IRubyObject iRubyObject = ((RubySystemExit)e.getException()).status();
                return iRubyObject;
            }
            runtime.printError(e.getException());
            throw new EvalFailedException(e.getMessage(), e);
        }
        catch (StackOverflowError soe) {
            throw runtime.newSystemStackError("stack level too deep", soe);
        }
        catch (Throwable e) {
            throw new EvalFailedException(e);
        }
        finally {
            if (sharing_variables) {
                threadContext.popScope();
            }
            vars.terminate();
        }
    }
}

