/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterfaceJavaProxy
extends JavaProxy {
    public InterfaceJavaProxy(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    public static RubyClass createInterfaceJavaProxy(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyClass ifcJavaProxy = runtime.defineClass("InterfaceJavaProxy", runtime.getJavaSupport().getJavaProxyClass(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new InterfaceJavaProxy(runtime, klazz);
            }
        });
        RubyClass javaIfcExtender = runtime.defineClass("JavaInterfaceExtender", runtime.getObject(), runtime.getObject().getAllocator());
        javaIfcExtender.defineAnnotatedMethods(JavaInterfaceExtender.class);
        return ifcJavaProxy;
    }

    public static class JavaInterfaceExtender {
        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject initialize(ThreadContext context, IRubyObject self2, IRubyObject javaClassName, Block block) {
            Ruby runtime = context.runtime;
            self2.getInstanceVariables().setInstanceVariable("@java_class", JavaClass.forNameVerbose(runtime, javaClassName.asJavaString()));
            self2.getInstanceVariables().setInstanceVariable("@block", RubyProc.newProc(runtime, block, block.type));
            return runtime.getNil();
        }

        @JRubyMethod
        public static IRubyObject extend_proxy(ThreadContext context, IRubyObject self2, IRubyObject proxyClass) {
            return proxyClass.callMethod(context, "class_eval", IRubyObject.NULL_ARRAY, ((RubyProc)self2.getInstanceVariables().getInstanceVariable("@block")).getBlock());
        }
    }
}

