/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNoArgNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Interpreted19Block
extends ContextAwareBlockBody {
    private static final boolean ALREADY_ARRAY = true;
    private final ISourcePosition position;
    private final String file;
    private final int line;
    private final ArgsNode args;
    private final boolean needsSplat;
    private final String[] parameterList;
    private final Node body;

    public static Block newInterpretedClosure(ThreadContext context, BlockBody body, IRubyObject self2) {
        Binding binding2 = context.currentBinding(self2);
        return new Block(body, binding2);
    }

    public static BlockBody newBlockBody(IterNode iter) {
        if (iter instanceof LambdaNode) {
            return new Interpreted19Block((LambdaNode)iter);
        }
        return new Interpreted19Block(iter);
    }

    public Interpreted19Block(IterNode iterNode) {
        super(iterNode.getScope(), ((ArgsNode)iterNode.getVarNode()).getArity(), -1);
        this.args = (ArgsNode)iterNode.getVarNode();
        this.needsSplat = Helpers.needsSplat19(this.args.getRequiredArgsCount(), this.args.getRestArg() != -1);
        this.parameterList = Helpers.encodeParameterList(this.args).split(";");
        this.body = iterNode.getBodyNode() == null ? NilImplicitNode.NIL : iterNode.getBodyNode();
        this.position = iterNode.getPosition();
        this.file = this.position.getFile();
        this.line = this.position.getLine();
    }

    public Interpreted19Block(LambdaNode lambdaNode) {
        super(lambdaNode.getScope(), lambdaNode.getArgs().getArity(), -1);
        this.args = lambdaNode.getArgs();
        this.needsSplat = Helpers.needsSplat19(this.args.getRequiredArgsCount(), this.args.getRestArg() != -1);
        this.parameterList = Helpers.encodeParameterList(this.args).split(";");
        this.body = lambdaNode.getBody() == null ? NilImplicitNode.NIL : lambdaNode.getBody();
        this.position = lambdaNode.getPosition();
        this.file = this.position.getFile();
        this.line = this.position.getLine();
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.yield(context, this.newArgsArrayFromArgsWithUnbox(args2, context), null, null, true, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, this.newArgsArrayFromArgsWithoutUnbox(args2, context), null, null, true, binding2, type2, block);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yield(context, null, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yield(context, context.runtime.newArrayNoCopyLight(arg0, arg1), null, null, true, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yield(context, context.runtime.newArrayNoCopyLight(arg0, arg1, arg2), null, null, true, binding2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject self2 = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            this.setupBlockArg(context, value2, self2, Block.NULL_BLOCK, type2);
            IRubyObject iRubyObject = this.evalBlockBody(context, binding2, self2);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = Helpers.handleNextJump(context, nj);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self2, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, self2, klass, aValue, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self2, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
        if (klass == null) {
            self2 = this.prepareSelf(binding2);
        }
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            this.setupBlockArgs(context, value2, self2, block, type2, aValue);
            IRubyObject iRubyObject = this.evalBlockBody(context, binding2, self2);
            return iRubyObject;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = Helpers.handleNextJump(context, nj);
            return iRubyObject;
        }
        finally {
            this.post(context, binding2, oldVis, lastFrame);
        }
    }

    /*
     * Loose catch block
     */
    private IRubyObject evalBlockBody(ThreadContext context, Binding binding2, IRubyObject self2) {
        while (true) {
            try {
                return ASTInterpreter.INTERPRET_BLOCK(context.runtime, context, this.file, this.line, this.body, binding2.getMethod(), self2, Block.NULL_BLOCK);
            }
            catch (JumpException.RedoJump rj) {
                context.pollThreadEvents();
                continue;
            }
            break;
        }
        catch (StackOverflowError soe) {
            throw context.runtime.newSystemStackError("stack level too deep", soe);
        }
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    private void setupBlockArg(ThreadContext context, IRubyObject value2, IRubyObject self2, Block block, Block.Type type2) {
        this.setupBlockArgs(context, value2, self2, block, type2, false);
    }

    private void setupBlockArgs(ThreadContext context, IRubyObject value2, IRubyObject self2, Block block, Block.Type type2, boolean alreadyArray) {
        IRubyObject[] parameters2 = Helpers.restructureBlockArgs19(value2, this.arity(), type2, this.needsSplat, alreadyArray);
        Ruby runtime = context.runtime;
        if (type2 == Block.Type.LAMBDA) {
            this.args.checkArgCount(runtime, parameters2.length);
        }
        if (!(this.args instanceof ArgsNoArgNode)) {
            this.args.prepare(context, runtime, self2, parameters2, block);
        }
    }

    public ArgsNode getArgs() {
        return this.args;
    }

    public Node getBody() {
        return this.body;
    }

    @Override
    public String getFile() {
        return this.position.getFile();
    }

    @Override
    public int getLine() {
        return this.position.getLine();
    }

    @Override
    public String[] getParameterList() {
        return this.parameterList;
    }
}

