/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariable
extends AbstractVariable {
    private static String pattern = "\\$(([a-zA-Z]|_|\\d)*|-[a-zA-Z]|[!-~&&[^#%()-\\{\\}\\[\\]\\|\\^]])";
    private static String[] patterns = new String[]{"\\$([\\u0021-\\u0040]|\\u005c|[\\u005e-\\u0060]|\\u007e)", "\\$-(\\d|[A-z])"};
    private static String[] predefined_names = new String[]{"$DEBUG", "$F", "$FILENAME", "$KCODE", "$LOAD_PATH", "$SAFE", "$VERBOSE", "$CLASSPATH", "$LOADED_FEATURES", "$PROGRAM_NAME", "$FIELD_SEPARATOR", "$ERROR_POSITION", "$DEFAULT_OUTPUT", "$PREMATCH", "$RS", "$MATCH", "$LAST_READ_LINE", "$FS", "$INPUT_RECORD_SEPARATOR", "$PID", "$NR", "$ERROR_INFO", "$PROCESS_ID", "$OUTPUT_RECORD_SEPARATOR", "$INPUT_LINE_NUMBER", "$LAST_PAREN_MATCH", "$LAST_MATCH_INFO", "$CHILD_STATUS", "$IGNORECASE", "$DEFAULT_INPUT", "$OFS", "$OUTPUT_FIELD_SEPARATOR", "$POSTMATCH", "$ORS", "$configure_args", "$deferr", "$defout", "$expect_verbose", "$stderr", "$stdin", "$stdout"};
    private static Set<String> predefined = new HashSet<String>();

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            GlobalVariable gvar = new GlobalVariable(receiver2, name2, javaObject);
            gvar.tryEagerInjection(receiver2.getRuntime(), null);
            return gvar;
        }
        return null;
    }

    protected GlobalVariable(RubyObject receiver2, String name2, Object ... javaObjects) {
        super(receiver2, name2, false);
        this.updateByJavaObject(receiver2.getRuntime(), javaObjects);
    }

    GlobalVariable(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public static void retrieve(IRubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        GlobalVariables gvars = receiver2.getRuntime().getGlobalVariables();
        Set<String> names2 = gvars.getNames();
        for (String name2 : names2) {
            if (GlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = gvars.get(name2);
            GlobalVariable.updateGlobalVar(vars, (RubyObject)receiver2.getRuntime().getTopSelf(), name2, value2);
        }
    }

    private static void updateGlobalVar(BiVariableMap vars, RubyObject receiver2, String name2, IRubyObject value2) {
        if (vars.containsKey(name2)) {
            BiVariable var = vars.getVariable(receiver2, name2);
            var.setRubyObject(value2);
        } else {
            GlobalVariable var = new GlobalVariable((IRubyObject)receiver2, name2, value2);
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(Ruby runtime, BiVariableMap vars, String key2) {
        GlobalVariables gvars = runtime.getGlobalVariables();
        if (!gvars.getNames().contains(key2)) {
            return;
        }
        IRubyObject value2 = gvars.get(key2);
        GlobalVariable.updateGlobalVar(vars, (RubyObject)runtime.getTopSelf(), key2, value2);
    }

    protected static boolean isPredefined(String name2) {
        for (String p2 : patterns) {
            if (!name2.matches(p2)) continue;
            return true;
        }
        return predefined.contains(name2);
    }

    @Override
    public BiVariable.Type getType() {
        return BiVariable.Type.GlobalVariable;
    }

    public static boolean isValidName(Object name2) {
        return GlobalVariable.isValidName(pattern, name2);
    }

    @Override
    public void setJavaObject(Ruby runtime, Object javaObject) {
        this.updateByJavaObject(runtime, javaObject);
        this.tryEagerInjection(runtime, null);
    }

    @Override
    public void inject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryEagerInjection(Ruby runtime, IRubyObject receiver2) {
        this.name = this.name.startsWith("$") ? this.name : ("$" + this.name).intern();
        Ruby ruby2 = this.getReceiver().getRuntime();
        synchronized (ruby2) {
            runtime.getGlobalVariables().set(this.name, this.irubyObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Ruby ruby2 = this.receiver.getRuntime();
        synchronized (ruby2) {
            this.receiver.getRuntime().getGlobalVariables().clear(this.name.intern());
        }
    }

    @Override
    public boolean isReceiverIdentical(RubyObject recv2) {
        return true;
    }

    static {
        predefined.addAll(Arrays.asList(predefined_names));
    }
}

