/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import mods.quiddity.redux.Engines.Engine;
import mods.quiddity.redux.Engines.JavaScript.ReduxJavascriptEngine;
import mods.quiddity.redux.Engines.Ruby.ReduxJRubyEngine;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Item;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;

public class Pack {
    @Nonnull
    protected String id;
    @Nonnull
    protected String name;
    @Nullable
    protected String author;
    @Nullable
    protected String description;
    @Nullable
    protected transient List<Block> block_list;
    @Nullable
    protected List<Item> item_list;
    private transient Map<String, Block> idMap = null;
    private transient boolean hasAddedBlocks = false;
    private transient Engine engine;

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<Block> getBlocks() {
        return this.block_list == null ? null : this.block_list;
    }

    public void setBlockList(List<Block> blocks2) {
        if (!this.hasAddedBlocks) {
            this.block_list = ImmutableList.copyOf(blocks2);
            this.hasAddedBlocks = true;
        }
    }

    public Block getBlockFromId(String id2) {
        if (this.getBlocks() == null || id2 == null) {
            return null;
        }
        if (this.idMap == null) {
            this.idMap = new HashMap<String, Block>();
            for (Block b2 : this.getBlocks()) {
                this.idMap.put(b2.getId(), b2);
            }
        }
        return this.idMap.get(id2);
    }

    public List<Item> getItems() {
        return this.item_list == null ? null : ImmutableList.copyOf(this.item_list);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public Engine getEngine() {
        block13: {
            String scriptExtention;
            if (this.engine != null) break block13;
            if (Redux.engineType == ReduxJavascriptEngine.class) {
                this.engine = new ReduxJavascriptEngine(this);
                scriptExtention = "js";
            } else if (Redux.engineType == ReduxJRubyEngine.class) {
                this.engine = new ReduxJRubyEngine(this);
                scriptExtention = "rb";
            } else {
                throw new AssertionError((Object)"Ummmm, a final field is null?");
            }
            this.engine.init();
            File packFile = Redux.instance.getReduxConfiguration().getSourceForPack(this);
            if (packFile.getParentFile().isDirectory()) {
                File scripts = new File(packFile.getParentFile(), "scripts");
                for (File script : FileUtils.listFiles((File)scripts, (String[])new String[]{scriptExtention}, (boolean)true)) {
                    try {
                        this.engine.loadScript(script.getName(), new FileInputStream(script));
                    }
                    catch (Exception e) {
                        Redux.instance.getLogger().warn("Redux pack inconsistency. The script file: %s has errors.", new Object[]{scripts.getName()});
                    }
                }
            } else {
                try {
                    ZipFile packZip = new ZipFile(packFile.getParentFile());
                    Enumeration entries2 = packZip.getEntries();
                    while (entries2.hasMoreElements()) {
                        ZipArchiveEntry entry = (ZipArchiveEntry)entries2.nextElement();
                        if (!entry.getName().endsWith(".".concat(scriptExtention))) continue;
                        InputStream scriptInputStream = packZip.getInputStream(entry);
                        this.engine.loadScript(entry.getName(), scriptInputStream);
                    }
                }
                catch (IOException e) {
                    Redux.instance.getLogger().warn("Redux pack inconsistency. The pack file %s has vanished!.", new Object[]{packFile.getParentFile().getName()});
                }
                catch (ScriptException e) {
                    Redux.instance.getLogger().warn("Redux pack inconsistency. A script file in pack: %s has errors.", new Object[]{packFile.getParentFile().getName()});
                }
            }
        }
        return this.engine;
    }

    public String toString() {
        return this.getName();
    }
}

