/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix.util;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.constants.platform.Errno;
import jnr.posix.POSIXHandler;

public class DefaultPOSIXHandler
implements POSIXHandler {
    public void error(Errno error2, String extraData) {
        throw new RuntimeException("native error " + error2.description() + " " + extraData);
    }

    public void error(Errno error2, String methodName, String extraData) {
        throw new RuntimeException("native error calling " + methodName + ": " + error2.description() + " " + extraData);
    }

    public void unimplementedError(String methodName) {
        throw new IllegalStateException(methodName + " is not implemented in jnr-posix");
    }

    public void warn(POSIXHandler.WARNING_ID id2, String message2, Object ... data2) {
        String msg;
        try {
            msg = String.format(message2, data2);
        }
        catch (IllegalFormatException e) {
            msg = message2 + " " + Arrays.toString(data2);
        }
        Logger.getLogger("jnr-posix").log(Level.WARNING, msg);
    }

    public boolean isVerbose() {
        return false;
    }

    public File getCurrentWorkingDirectory() {
        return new File(".");
    }

    public String[] getEnv() {
        String[] envp = new String[System.getenv().size()];
        int i2 = 0;
        for (Map.Entry<String, String> pair : System.getenv().entrySet()) {
            envp[i2++] = pair.getKey() + "=" + pair.getValue();
        }
        return envp;
    }

    public InputStream getInputStream() {
        return System.in;
    }

    public PrintStream getOutputStream() {
        return System.out;
    }

    public int getPID() {
        return 0;
    }

    public PrintStream getErrorStream() {
        return System.err;
    }
}

