/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.Engines;

import mods.quiddity.redux.Engines.Engine;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.StringUtils;

public class ReduxAPI
implements ICommandSender {
    private Engine reduxEngine;
    private Entity lastEntity = null;
    private World lastWorld = null;
    private BlockPos lastBlockPos = null;

    public ReduxAPI(Engine reduxEngine) {
        this.reduxEngine = reduxEngine;
    }

    public int runCommand(String ... args) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && FMLCommonHandler.instance().getMinecraftServerInstance().isCallingFromMinecraftThread()) {
            this.lastEntity = this.reduxEngine.globalObjectExists("entity") && this.reduxEngine.getJavaObject("entity", Entity.class) instanceof Entity ? (Entity)this.reduxEngine.getJavaObject("entity", Entity.class) : null;
            this.lastWorld = this.reduxEngine.globalObjectExists("world") && this.reduxEngine.getJavaObject("world", World.class) instanceof World ? (World)this.reduxEngine.getJavaObject("world", World.class) : null;
            this.lastBlockPos = this.reduxEngine.globalObjectExists("pos") && this.reduxEngine.getJavaObject("pos", BlockPos.class) instanceof BlockPos ? (BlockPos)this.reduxEngine.getJavaObject("pos", BlockPos.class) : null;
            ICommandManager manager = FMLCommonHandler.instance().getMinecraftServerInstance().getCommandManager();
            manager.executeCommand((ICommandSender)this, StringUtils.join((Object[])args));
        }
        return 0;
    }

    public String getName() {
        return this.reduxEngine.getPackReference().getName();
    }

    public IChatComponent getDisplayName() {
        return new ChatComponentText(this.reduxEngine.getPackReference().getName());
    }

    public void addChatMessage(IChatComponent message) {
    }

    public boolean canUseCommand(int permLevel, String commandName) {
        return permLevel <= 2;
    }

    public BlockPos getPosition() {
        return this.lastBlockPos == null ? (this.lastEntity == null ? new BlockPos(0, 0, 0) : this.lastEntity.getPosition()) : this.lastBlockPos;
    }

    public Vec3 getPositionVector() {
        return this.lastBlockPos == null ? (this.lastEntity == null ? new Vec3(0.0, 0.0, 0.0) : this.lastEntity.getPositionVector()) : new Vec3((double)this.lastBlockPos.getX(), (double)this.lastBlockPos.getY(), (double)this.lastBlockPos.getZ());
    }

    public World getEntityWorld() {
        return this.lastWorld == null ? (this.lastEntity == null ? null : this.lastEntity.worldObj) : this.lastWorld;
    }

    public Entity getCommandSenderEntity() {
        return this.lastEntity;
    }

    public boolean sendCommandFeedback() {
        return false;
    }

    public void setCommandStat(CommandResultStats.Type type, int amount) {
    }
}

