/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.CompatVersion;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.jruby.JRubyLibrary;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.CompiledBlockLight19;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Method"})
public class RubyMethod
extends AbstractRubyMethod {
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime) {
        RubyClass methodClass = runtime.defineClass("Method", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setMethod(methodClass);
        methodClass.index = 34;
        methodClass.setReifiedClass(RubyMethod.class);
        methodClass.defineAnnotatedMethods(AbstractRubyMethod.class);
        methodClass.defineAnnotatedMethods(RubyMethod.class);
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method2, IRubyObject receiver2) {
        Ruby runtime = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime, runtime.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method2;
        newMethod.receiver = receiver2;
        return newMethod;
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg0, arg1, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, args2, block);
    }

    @Override
    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyMethod)) {
            return context.runtime.getFalse();
        }
        if (this.method instanceof ProcMethod) {
            return context.runtime.newBoolean(((ProcMethod)this.method).isSame(((RubyMethod)other).getMethod()));
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return context.runtime.newBoolean(this.receiver == otherMethod.receiver && this.originModule == otherMethod.originModule && this.method.getRealMethod().getSerialNumber() == otherMethod.method.getRealMethod().getSerialNumber());
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method, this.receiver);
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context, Block unusedBlock) {
        Ruby runtime = context.runtime;
        CompiledBlockCallback19 callback = new CompiledBlockCallback19(){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
                return RubyMethod.this.method.call(context, RubyMethod.this.receiver, RubyMethod.this.originModule, RubyMethod.this.originName, args2, block);
            }

            @Override
            public String getFile() {
                return RubyMethod.this.getFilename();
            }

            @Override
            public int getLine() {
                return RubyMethod.this.getLine();
            }
        };
        BlockBody body = CompiledBlockLight19.newCompiledBlockLight(this.method.getArity(), runtime.getStaticScopeFactory().getDummyScope(), callback, false, 0, JRubyLibrary.MethodExtensions.methodParameters(runtime, this.method));
        Block b2 = new Block(body, context.currentBinding(this.receiver, Visibility.PUBLIC));
        return RubyProc.newProc(runtime, b2, Block.Type.LAMBDA);
    }

    @JRubyMethod
    public RubyUnboundMethod unbind() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        unboundMethod.infectBy(this);
        return unboundMethod;
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        int delimeter = 35;
        buf.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.implementationModule.isSingleton()) {
            IRubyObject attached = ((MetaClass)this.implementationModule).getAttached();
            if (this.receiver == null) {
                buf.append(this.implementationModule.inspect().toString());
            } else if (this.receiver == attached) {
                buf.append(attached.inspect().toString());
                delimeter = 46;
            } else {
                buf.append(this.receiver.inspect().toString());
                buf.append('(').append(attached.inspect().toString()).append(')');
                delimeter = 46;
            }
        } else {
            buf.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                buf.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        buf.append((char)delimeter).append(this.methodName).append('>');
        RubyString str = this.getRuntime().newString(buf.toString());
        str.setTaint(this.isTaint());
        return str;
    }

    @Override
    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject name(ThreadContext context) {
        return context.runtime.newString(this.methodName);
    }

    @Override
    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject name19(ThreadContext context) {
        return context.runtime.newSymbol(this.methodName);
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @JRubyMethod(name={"receiver"})
    public IRubyObject receiver(ThreadContext context) {
        return this.receiver;
    }

    @Override
    @JRubyMethod(name={"owner"})
    public IRubyObject owner(ThreadContext context) {
        return this.implementationModule;
    }

    @Override
    @JRubyMethod(name={"source_location"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime = context.runtime;
        String filename2 = this.getFilename();
        if (filename2 != null) {
            return runtime.newArray((IRubyObject)runtime.newString(filename2), (IRubyObject)runtime.newFixnum(this.getLine()));
        }
        return context.runtime.getNil();
    }

    @Override
    public String getFilename() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getFile();
        }
        return null;
    }

    @Override
    public int getLine() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getLine() + 1;
        }
        return -1;
    }

    @Override
    @JRubyMethod(name={"parameters"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject parameters(ThreadContext context) {
        return JRubyLibrary.MethodExtensions.methodArgs(this);
    }
}

