/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyConstructor
extends JavaProxyReflectionObject
implements ParameterTypes {
    private final Constructor<?> proxyConstructor;
    private final Class<?>[] apparentParameterTypes;
    private final JavaProxyClass declaringProxyClass;

    JavaProxyConstructor(Ruby runtime, JavaProxyClass pClass, Constructor<?> constructor2) {
        super(runtime, runtime.getJavaSupport().getJavaModule().getClass("JavaProxyConstructor"));
        this.declaringProxyClass = pClass;
        this.proxyConstructor = constructor2;
        Class<?>[] parameterTypes = constructor2.getParameterTypes();
        int len = parameterTypes.length - 1;
        this.apparentParameterTypes = new Class[len];
        System.arraycopy(parameterTypes, 0, this.apparentParameterTypes, 0, len);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.apparentParameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.proxyConstructor.getExceptionTypes();
    }

    @Override
    public boolean isVarArgs() {
        return this.proxyConstructor.isVarArgs();
    }

    @JRubyMethod(name={"declaring_class"})
    public JavaProxyClass getDeclaringClass() {
        return this.declaringProxyClass;
    }

    public Object newInstance(Object[] args2, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (args2.length != this.apparentParameterTypes.length) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        Object[] realArgs = new Object[args2.length + 1];
        System.arraycopy(args2, 0, realArgs, 0, args2.length);
        realArgs[args2.length] = handler;
        return this.proxyConstructor.newInstance(realArgs);
    }

    public static RubyClass createJavaProxyConstructorClass(Ruby runtime, RubyModule javaProxyModule) {
        RubyClass result2 = javaProxyModule.defineClassUnder("JavaProxyConstructor", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(runtime, result2);
        result2.defineAnnotatedMethods(JavaProxyConstructor.class);
        return result2;
    }

    @JRubyMethod
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getParameterTypes().length);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaProxyConstructor && this.proxyConstructor == ((JavaProxyConstructor)other).proxyConstructor;
    }

    @Override
    public int hashCode() {
        return this.proxyConstructor.hashCode();
    }

    protected String nameOnInspection() {
        return this.getDeclaringClass().nameOnInspection();
    }

    @Override
    public IRubyObject inspect() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.nameOnInspection());
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            result2.append(parameterTypes[i2].getName());
            if (i2 >= parameterTypes.length - 1) continue;
            result2.append(',');
        }
        result2.append(")>");
        return this.getRuntime().newString(result2.toString());
    }

    @JRubyMethod
    public RubyArray argument_types() {
        return this.buildRubyArray(this.getParameterTypes());
    }

    @JRubyMethod(rest=true)
    public RubyObject new_instance2(IRubyObject[] args2, Block unusedBlock) {
        Arity.checkArgumentCount(this.getRuntime(), args2, 2, 2);
        final IRubyObject self2 = args2[0];
        final Ruby runtime = self2.getRuntime();
        RubyArray constructor_args = (RubyArray)args2[1];
        Class<?>[] parameterTypes = this.getParameterTypes();
        int count2 = (int)constructor_args.length().getLongValue();
        Object[] converted = new Object[count2];
        for (int i2 = 0; i2 < count2; ++i2) {
            IRubyObject ith = constructor_args.aref(this.getRuntime().newFixnum(i2));
            converted[i2] = ith.toJava(parameterTypes[i2]);
        }
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            @Override
            public IRubyObject getOrig() {
                return self2;
            }

            @Override
            public Object invoke(Object proxy2, JavaProxyMethod m, Object[] nargs) throws Throwable {
                String name2 = m.getName();
                DynamicMethod method2 = self2.getMetaClass().searchMethod(name2);
                int v = method2.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[nargs.length];
                int i2 = nargs.length;
                while (--i2 >= 0) {
                    newArgs[i2] = JavaUtil.convertJavaToUsableRubyObject(runtime, nargs[i2]);
                }
                if (v < 0 || v == newArgs.length) {
                    return method2.call(runtime.getCurrentContext(), self2, (RubyModule)self2.getMetaClass(), name2, newArgs).toJava(m.getReturnType());
                }
                if (m.hasSuperImplementation()) {
                    RubyClass superClass = self2.getMetaClass().getSuperClass();
                    return Helpers.invokeAs(runtime.getCurrentContext(), superClass, self2, name2, newArgs, Block.NULL_BLOCK).toJava(m.getReturnType());
                }
                throw runtime.newArgumentError(newArgs.length, v);
            }
        };
        try {
            return JavaObject.wrap(this.getRuntime(), this.newInstance(converted, handler));
        }
        catch (Exception e) {
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public JavaObject newInstance(final IRubyObject self2, Object[] args2) {
        final Ruby runtime = self2.getRuntime();
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            @Override
            public IRubyObject getOrig() {
                return self2;
            }

            @Override
            public Object invoke(Object proxy2, JavaProxyMethod m, Object[] nargs) throws Throwable {
                String name2 = m.getName();
                DynamicMethod method2 = self2.getMetaClass().searchMethod(name2);
                int v = method2.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[nargs.length];
                int i2 = nargs.length;
                while (--i2 >= 0) {
                    newArgs[i2] = JavaUtil.convertJavaToUsableRubyObject(runtime, nargs[i2]);
                }
                IRubyObject result2 = null;
                if (v < 0 || v == newArgs.length) {
                    result2 = method2.call(runtime.getCurrentContext(), self2, (RubyModule)self2.getMetaClass(), name2, newArgs);
                } else if (m.hasSuperImplementation()) {
                    RubyClass superClass = self2.getMetaClass().getSuperClass();
                    result2 = Helpers.invokeAs(runtime.getCurrentContext(), superClass, self2, name2, newArgs, Block.NULL_BLOCK);
                } else {
                    throw runtime.newArgumentError(newArgs.length, v);
                }
                if (m.getReturnType() == Void.TYPE) {
                    return null;
                }
                return result2.toJava(m.getReturnType());
            }
        };
        try {
            return JavaObject.wrap(this.getRuntime(), this.newInstance(args2, handler));
        }
        catch (Throwable t) {
            while (t.getCause() != null) {
                t = t.getCause();
            }
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + t.getMessage());
            ex.initCause(t);
            throw ex;
        }
    }

    @JRubyMethod(required=1, optional=1)
    public RubyObject new_instance(IRubyObject[] args2, Block block) {
        Object result2;
        RubyProc proc2;
        int size2 = Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) - 1;
        if (args2[size2] instanceof RubyProc) {
            proc2 = (RubyProc)args2[size2];
        } else {
            proc2 = this.getRuntime().newProc(Block.Type.PROC, block);
            ++size2;
        }
        RubyArray constructor_args = (RubyArray)args2[0];
        Class<?>[] parameterTypes = this.getParameterTypes();
        int count2 = (int)constructor_args.length().getLongValue();
        Object[] converted = new Object[count2];
        for (int i2 = 0; i2 < count2; ++i2) {
            IRubyObject ith = constructor_args.aref(this.getRuntime().newFixnum(i2));
            converted[i2] = ith.toJava(parameterTypes[i2]);
        }
        final JavaProxyConstructor recv2 = this;
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            @Override
            public IRubyObject getOrig() {
                return null;
            }

            @Override
            public Object invoke(Object proxy2, JavaProxyMethod method2, Object[] nargs) throws Throwable {
                int length2 = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length2 + 2];
                rubyArgs[0] = JavaObject.wrap(recv2.getRuntime(), proxy2);
                rubyArgs[1] = method2;
                for (int i2 = 0; i2 < length2; ++i2) {
                    rubyArgs[i2 + 2] = JavaUtil.convertJavaToRuby(JavaProxyConstructor.this.getRuntime(), nargs[i2]);
                }
                IRubyObject call_result = proc2.call(JavaProxyConstructor.this.getRuntime().getCurrentContext(), rubyArgs);
                Object converted_result = call_result.toJava(method2.getReturnType());
                return converted_result;
            }
        };
        try {
            result2 = this.newInstance(converted, handler);
        }
        catch (Exception e) {
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return JavaObject.wrap(this.getRuntime(), result2);
    }
}

