/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.quiddity.redux.ReduxBlock;
import mods.quiddity.redux.ReduxCommandBlockTileEntity;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ReduxCommands {
    public static final ReduxCommand TEST_FOR_TRIGGER = new ReduxCommand("testfortrigger", "/testfortrigger <trigger type>", new ReduxCommandRunnable(){

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            block5: {
                if (args.length < 1) {
                    throw new CommandException("Incorrect parameters", new Object[0]);
                }
                String trigger = args[0];
                try {
                    Trigger.TriggerEvent event = Trigger.TriggerEvent.valueOf(trigger);
                    if (event == null) break block5;
                    if (sender instanceof ReduxCommandBlockTileEntity.ReduxBlockEventReceiver) {
                        ReduxCommandBlockTileEntity.ReduxBlockEventReceiver reduxBlockEventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)sender;
                        if (Trigger.TriggerEvent.getTriggerEventFromForgeEvent(reduxBlockEventReceiver.getLastEvent().getClass()) == event) {
                            return;
                        }
                        break block5;
                    }
                    throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
                }
                catch (IllegalArgumentException ignored) {
                    throw new CommandException("Trigger type %s does not exist!", new Object[]{trigger});
                }
            }
            throw new CommandException("failure", new Object[0]);
        }
    });
    public static final ReduxCommand TEST_FOR_PROPERTY = new ReduxCommand("testforproperty", "/testforproperty <property name> <integer value>", new ReduxCommandRunnable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            int testValue;
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                testValue = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Second parameter must be an integer!", new Object[0]);
            }
            if (!(sender instanceof ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            ReduxCommandBlockTileEntity.ReduxBlockEventReceiver reduxBlockEventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)sender;
            IBlockState blockState = sender.func_130014_f_().func_180495_p(reduxBlockEventReceiver.func_180425_c());
            if (!(blockState.func_177230_c() instanceof ReduxBlock)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            PropertyInteger property = ((ReduxBlock)blockState.func_177230_c()).getPropertyFromName(args[0]);
            if (property != null && blockState.func_177229_b((IProperty)property) != null && blockState.func_177229_b((IProperty)property).equals(testValue)) throw new CommandException("failure", new Object[0]);
            throw new CommandException("failure", new Object[0]);
        }
    });
    public static final ReduxCommand SET_PROPERTY = new ReduxCommand("setproperty", "/setproperty <property name> <integer value>", new ReduxCommandRunnable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            int setValue;
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                setValue = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Second parameter must be an integer!", new Object[0]);
            }
            if (!(sender instanceof ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            ReduxCommandBlockTileEntity.ReduxBlockEventReceiver reduxBlockEventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)sender;
            IBlockState blockState = sender.func_130014_f_().func_180495_p(reduxBlockEventReceiver.func_180425_c());
            if (!(blockState.func_177230_c() instanceof ReduxBlock)) throw new CommandException("This command is only useful in Redux Pack Blocks", new Object[0]);
            PropertyInteger property = ((ReduxBlock)blockState.func_177230_c()).getPropertyFromName(args[0]);
            if (property == null || blockState.func_177229_b((IProperty)property) == null) throw new CommandException("failure", new Object[0]);
            reduxBlockEventReceiver.func_130014_f_().func_175656_a(reduxBlockEventReceiver.func_180425_c(), blockState.func_177226_a((IProperty)property, (Comparable)Integer.valueOf(setValue)));
        }
    });
    public static final ReduxCommand TEST = new ReduxCommand("test", "/test <value(string or integer) 1> <operation> <value(string or integer) 2>", new ReduxCommandRunnable(){

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            if (args.length < 3) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            int result = 0;
            try {
                if (args[1].equalsIgnoreCase("&&")) {
                    result = Boolean.valueOf(args[0]) != false && Boolean.valueOf(args[2]) != false ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("||")) {
                    result = Boolean.valueOf(args[0]) != false || Boolean.valueOf(args[2]) != false ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("==")) {
                    result = Integer.valueOf(args[0]).equals(Integer.valueOf(args[2])) ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("!=")) {
                    result = !Integer.valueOf(args[0]).equals(Integer.valueOf(args[2])) ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("<")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) > 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase(">")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) < 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("<=")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) >= 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("=>")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) <= 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("&")) {
                    result = Integer.valueOf(args[0]) & Integer.valueOf(args[2]);
                } else if (args[1].equalsIgnoreCase("|")) {
                    result = Integer.valueOf(args[0]) | Integer.valueOf(args[2]);
                }
                if (args[1].equalsIgnoreCase("^")) {
                    result = Integer.valueOf(args[0]) ^ Integer.valueOf(args[2]);
                }
            }
            catch (NumberFormatException e) {
                result = args[1].equalsIgnoreCase("==") ? (args[0].equalsIgnoreCase(args[2]) ? 1 : 0) : (args[0].equalsIgnoreCase(args[2]) ? 0 : 1);
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(result)));
            if (sender instanceof ReduxCommandBlockTileEntity.ReduxBlockEventReceiver) {
                ReduxCommandBlockTileEntity.ReduxBlockEventReceiver eventReceiver = (ReduxCommandBlockTileEntity.ReduxBlockEventReceiver)sender;
                eventReceiver.setLastTest(result);
            }
            if (result == 0) {
                throw new CommandException("failure", new Object[0]);
            }
        }
    });
    public static final ReduxCommand RANDOM = new ReduxCommand("random", "/random <lower> <upper>", new ReduxCommandRunnable(){
        private final Random random = new Random();

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                int lower = Integer.parseInt(args[0]);
                int upper = Integer.parseInt(args[1]);
                int rand = lower + this.random.nextInt(upper - lower + 1);
                sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(rand)));
            }
            catch (NumberFormatException e) {
                throw new CommandException("First and Second parameters must be integers!", new Object[0]);
            }
        }
    });
    private static final List<ICommand> commands = new ArrayList<ICommand>();

    public static List<ICommand> getCommands() {
        return ImmutableList.copyOf(commands);
    }

    static {
        commands.add((ICommand)TEST_FOR_TRIGGER);
        commands.add((ICommand)TEST_FOR_PROPERTY);
        commands.add((ICommand)SET_PROPERTY);
        commands.add((ICommand)TEST);
        commands.add((ICommand)RANDOM);
    }

    public static class ReduxCommand
    extends CommandBase {
        private final String name;
        private final String commandUsage;
        private final ReduxCommandRunnable commandRunnable;

        public ReduxCommand(String name, String usage, ReduxCommandRunnable runnable) {
            this.name = name;
            this.commandUsage = usage;
            this.commandRunnable = runnable;
        }

        public int func_82362_a() {
            return 2;
        }

        public String func_71517_b() {
            return this.name;
        }

        public String func_71518_a(ICommandSender sender) {
            return this.commandUsage;
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            this.commandRunnable.run(sender, args);
        }
    }

    private static abstract class ReduxCommandRunnable {
        private ReduxCommandRunnable() {
        }

        public abstract void run(ICommandSender var1, String ... var2) throws CommandException;
    }
}

