/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.quiddity.redux.Redux;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Trigger {
    @Nonnull
    protected String trigger;
    @Nullable
    protected boolean on_cause = true;
    @Nonnull
    protected List<String> commands;

    public TriggerEvent getTriggerEvent() {
        if (this.trigger == null || this.trigger.isEmpty()) {
            Redux.instance.getLogger().warn("A block tried to register a trigger that is either empty or null.");
            return null;
        }
        return TriggerEvent.valueOf(this.trigger);
    }

    public List<String> getCommands() {
        if (this.commands == null || this.commands.isEmpty()) {
            Redux.instance.getLogger().warn("A block tried to register a trigger that has no commands.");
            return null;
        }
        return ImmutableList.copyOf(this.commands);
    }

    public boolean blockHasToBeTheCause() {
        return this.on_cause;
    }

    public static enum TriggerEvent {
        BlockHarvestDropsEvent(BlockEvent.HarvestDropsEvent.class),
        BlockBreakEvent(BlockEvent.BreakEvent.class),
        BlockPlaceEvent(BlockEvent.PlaceEvent.class),
        BlockMultiPlaceEvent(BlockEvent.MultiPlaceEvent.class),
        WorldLoad(WorldEvent.Load.class),
        WorldUnload(WorldEvent.Unload.class),
        WorldPotentialSpawns(WorldEvent.PotentialSpawns.class),
        WorldCreateSpawnPosition(WorldEvent.CreateSpawnPosition.class),
        ExplosionStart(ExplosionEvent.Start.class),
        ExplosionDetonate(ExplosionEvent.Detonate.class),
        ChunkWatch(ChunkWatchEvent.Watch.class),
        ChunkUnWatch(ChunkWatchEvent.UnWatch.class),
        ServerChatEvent(ServerChatEvent.class),
        OnTick(Event.class),
        OnEntityCollide(Event.class),
        OnInteract(Event.class),
        OnRestoneStrengthChange(Event.class);

        private Class<? extends Event> forgeEventClass;

        private TriggerEvent(Class<? extends Event> forgeEvent) {
            this.forgeEventClass = forgeEvent;
        }

        public Class<? extends Event> getForgeEventClass() {
            return this.forgeEventClass;
        }

        public static TriggerEvent getTriggerEventFromForgeEvent(Class<? extends Event> forgeEvent) {
            for (TriggerEvent e : TriggerEvent.values()) {
                if (e.forgeEventClass != forgeEvent) continue;
                return e;
            }
            return null;
        }
    }
}

