package mods.quiddity.redux.loader;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.model.Pack;
import net.minecraftforge.fml.common.*;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;

import java.io.File;
import java.security.cert.Certificate;
import java.util.*;

/**
 * Dummy mod container to allow our custom resource pack to load the external resources requested by the packs.
 *
 * @author winsock on 2/4/15.
 */
public class ReduxPackModContainer implements ModContainer {

    private final File packFile;
    private ModMetadata packMetadata;

    public ReduxPackModContainer(Pack reduxPack, Redux redux) {
        this.packFile = Redux.instance.getReduxConfiguration().getSourceForPack(reduxPack);

        packMetadata = new ModMetadata();
        packMetadata.authorList = Lists.newArrayList(reduxPack.getAuthor());
        packMetadata.autogenerated = true;
        // TODO: packMetadata.credits
        packMetadata.description = reduxPack.getDescription();
        packMetadata.modId = reduxPack.getId();
        packMetadata.name = reduxPack.getName();
        packMetadata.parentMod = FMLCommonHandler.instance().findContainerFor(redux);
        packMetadata.requiredMods = Sets.newHashSet(FMLCommonHandler.instance().findContainerFor(redux).getProcessedVersion());
        packMetadata.useDependencyInformation = false;
        // TODO: packMetadata.version
    }

    @Override
    public String getModId() {
        return packMetadata.modId;
    }

    @Override
    public String getName() {
        return packMetadata.name;
    }

    @Override
    public String getVersion() {
        return packMetadata.version;
    }

    @Override
    public File getSource() {
        return packFile;
    }

    @Override
    public ModMetadata getMetadata() {
        return packMetadata;
    }

    @Override
    public void bindMetadata(MetadataCollection mc) { }

    @Override
    public void setEnabledState(boolean enabled) { }

    @Override
    public Set<ArtifactVersion> getRequirements() {
        return packMetadata.requiredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return Collections.emptyList();
    }

    @Override
    public String getSortingRules() {
        return "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register(this);
        return true;
    }

    @Override
    public boolean matches(Object mod) {
        return false;
    }

    @Override
    public Object getMod() {
        return null;
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        return null;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public String getDisplayVersion() {
        return packMetadata.version;
    }

    @Override
    public VersionRange acceptableMinecraftVersionRange() {
        return null;
    }

    @Override
    public Certificate getSigningCertificate() {
        return null;
    }

    @Override
    public Map<String, String> getCustomModProperties() {
        return Collections.emptyMap();
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return ReduxResourcePack.class;
    }

    @Override
    public Map<String, String> getSharedModDescriptor() {
        return Collections.emptyMap();
    }

    @Override
    public Disableable canBeDisabled() {
        return Disableable.NEVER;
    }

    @Override
    public String getGuiClassName() {
        return null;
    }

    @Override
    public List<String> getOwnedPackages() {
        return Collections.emptyList();
    }
}
