/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.loader;

import java.lang.reflect.Method;
import java.util.ArrayList;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.ReduxBlock;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Config;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.loader.ReduxPackModContainer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;

public class ReduxPackLoader {
    private final Config configuration;

    public ReduxPackLoader(Config mainConfig) {
        this.configuration = mainConfig;
    }

    public void loadPacks() {
        ArrayList<ReduxPackModContainer> children = new ArrayList<ReduxPackModContainer>();
        if (this.configuration.getPacks() == null) {
            Redux.instance.getLogger().info("No packs installed. Without packs this mod does nothing.");
            return;
        }
        for (Pack p : this.configuration.getPacks()) {
            ReduxPackModContainer packContainer = new ReduxPackModContainer(p, Redux.instance);
            FMLCommonHandler.instance().addModToResourcePack((ModContainer)packContainer);
            children.add(packContainer);
            if (p.getBlocks() == null) continue;
            for (Block b : p.getBlocks()) {
                ReduxBlock.blockThreadLocal.set(b);
                ReduxBlock mcBlock = new ReduxBlock(p, b);
                ReduxBlock.blockThreadLocal.remove();
                ItemBlock blockItem = new ItemBlock((net.minecraft.block.Block)mcBlock);
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    FMLClientHandler.instance().getClient().func_175599_af().func_175037_a().func_178086_a((Item)blockItem, 0, new ModelResourceLocation(p.getId() + ":" + b.getId(), "inventory"));
                }
                try {
                    Class<GameData> gameDataClass = GameData.class;
                    Method mainDataGetMethod = gameDataClass.getDeclaredMethod("getMain", new Class[0]);
                    mainDataGetMethod.setAccessible(true);
                    Method registerBlockMethod = gameDataClass.getDeclaredMethod("registerBlock", net.minecraft.block.Block.class, String.class, Integer.TYPE);
                    registerBlockMethod.setAccessible(true);
                    Method registerItemMethod = gameDataClass.getDeclaredMethod("registerItem", Item.class, String.class, Integer.TYPE);
                    registerItemMethod.setAccessible(true);
                    GameData gameData = (GameData)mainDataGetMethod.invoke(null, new Object[0]);
                    registerBlockMethod.invoke((Object)gameData, new Object[]{mcBlock, p.getId() + ":" + b.getId(), -1});
                    registerItemMethod.invoke((Object)gameData, blockItem, p.getId() + ":" + b.getId(), -1);
                    GameData.getBlockItemMap().put(mcBlock, blockItem);
                    if (!mcBlock.hasTileEntity(null) || mcBlock.getTileEntityClass() == null) continue;
                    TileEntity.func_145826_a(mcBlock.getTileEntityClass(), (String)b.getId());
                }
                catch (Exception e) {
                    Redux.instance.getLogger().fatal("Error accessing FML GameData.\nRedux will not function properly!\nDid FML Update?", (Throwable)e);
                }
            }
        }
        FMLCommonHandler.instance().findContainerFor((Object)Redux.instance).getMetadata().childMods = children;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            FMLClientHandler.instance().addSpecialModEntries(children);
        }
    }
}

