/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.loader;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.loader.ReduxResourcePack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;

public class ReduxPackModContainer
implements ModContainer {
    private final File packFile;
    private ModMetadata packMetadata;

    public ReduxPackModContainer(Pack reduxPack, Redux redux) {
        this.packFile = Redux.instance.getReduxConfiguration().getSourceForPack(reduxPack);
        this.packMetadata = new ModMetadata();
        this.packMetadata.authorList = Lists.newArrayList((Object[])new String[]{reduxPack.getAuthor()});
        this.packMetadata.autogenerated = true;
        this.packMetadata.description = reduxPack.getDescription();
        this.packMetadata.modId = reduxPack.getId();
        this.packMetadata.name = reduxPack.getName();
        this.packMetadata.parentMod = FMLCommonHandler.instance().findContainerFor((Object)redux);
        this.packMetadata.requiredMods = Sets.newHashSet((Object[])new ArtifactVersion[]{FMLCommonHandler.instance().findContainerFor((Object)redux).getProcessedVersion()});
        this.packMetadata.useDependencyInformation = false;
    }

    public String getModId() {
        return this.packMetadata.modId;
    }

    public String getName() {
        return this.packMetadata.name;
    }

    public String getVersion() {
        return this.packMetadata.version;
    }

    public File getSource() {
        return this.packFile;
    }

    public ModMetadata getMetadata() {
        return this.packMetadata;
    }

    public void bindMetadata(MetadataCollection mc) {
    }

    public void setEnabledState(boolean enabled) {
    }

    public Set<ArtifactVersion> getRequirements() {
        return this.packMetadata.requiredMods;
    }

    public List<ArtifactVersion> getDependencies() {
        return Collections.emptyList();
    }

    public List<ArtifactVersion> getDependants() {
        return Collections.emptyList();
    }

    public String getSortingRules() {
        return "";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public boolean matches(Object mod) {
        return false;
    }

    public Object getMod() {
        return null;
    }

    public ArtifactVersion getProcessedVersion() {
        return null;
    }

    public boolean isImmutable() {
        return true;
    }

    public String getDisplayVersion() {
        return this.packMetadata.version;
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return null;
    }

    public Certificate getSigningCertificate() {
        return null;
    }

    public Map<String, String> getCustomModProperties() {
        return Collections.emptyMap();
    }

    public Class<?> getCustomResourcePackClass() {
        return ReduxResourcePack.class;
    }

    public Map<String, String> getSharedModDescriptor() {
        return Collections.emptyMap();
    }

    public ModContainer.Disableable canBeDisabled() {
        return ModContainer.Disableable.NEVER;
    }

    public String getGuiClassName() {
        return null;
    }

    public List<String> getOwnedPackages() {
        return Collections.emptyList();
    }
}

