/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mods.quiddity.redux.json.model.Flags;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class Block {
    private String id;
    private String name;
    private String description;
    private String material;
    private boolean full_cube;
    private List<CollisionBox> collisionBoxes;
    private boolean directional;
    private List<Flags<String, Integer>> custom_properties;
    private List<String> ignored_properties;
    private String creative_tab;
    private String creative_tab_icon;
    private int tick_rate;
    private List<String> ore_dictionary;
    private List<Trigger> script;
    private transient CreativeTabs creativeTabObject = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getTickRate() {
        return this.tick_rate;
    }

    public boolean tickable() {
        return this.tick_rate > 0;
    }

    public Material getMaterial() {
        try {
            return (Material)Material.class.getField(this.material).get(null);
        }
        catch (Exception e) {
            return Material.air;
        }
    }

    public boolean shouldAddFacingProperty() {
        return this.directional;
    }

    public List<CollisionBox> getCollisionBoxes() {
        if (this.collisionBoxes != null) {
            return ImmutableList.copyOf(this.collisionBoxes);
        }
        return null;
    }

    public boolean hasMultipleCollisionBoxes() {
        return this.collisionBoxes != null && this.collisionBoxes.size() > 1;
    }

    public boolean isFullCube() {
        return this.full_cube;
    }

    public CreativeTabs getCreativeTab() {
        if (this.creativeTabObject == null) {
            for (CreativeTabs tab : CreativeTabs.creativeTabArray) {
                if (!tab.getTabLabel().equalsIgnoreCase(this.creative_tab)) continue;
                this.creativeTabObject = tab;
            }
            if (this.creativeTabObject == null) {
                this.creativeTabObject = new CreativeTabs(this.creative_tab){

                    public Item getTabIconItem() {
                        return Item.getByNameOrId((String)Block.this.creative_tab_icon);
                    }
                };
            }
        }
        return this.creativeTabObject;
    }

    public List<Trigger> getScript() {
        return ImmutableList.copyOf(this.script);
    }

    public List<String> getOreDictionaryNames() {
        return ImmutableList.copyOf(this.ore_dictionary);
    }

    public List<Flags<String, Integer>> getCustomProperties() {
        if (this.custom_properties == null) {
            return null;
        }
        return ImmutableList.copyOf(this.custom_properties);
    }

    public List<String> getIgnoredProperties() {
        if (this.ignored_properties == null) {
            return null;
        }
        return ImmutableList.copyOf(this.ignored_properties);
    }

    public String toString() {
        return this.id + " - " + this.description;
    }

    public class CollisionBox {
        private float minX;
        private float minY;
        private float minZ;
        private float maxX;
        private float maxY;
        private float maxZ;

        public float getMinX() {
            return this.minX;
        }

        public float getMinY() {
            return this.minY;
        }

        public float getMinZ() {
            return this.minZ;
        }

        public float getMaxX() {
            return this.maxX;
        }

        public float getMaxY() {
            return this.maxY;
        }

        public float getMaxZ() {
            return this.maxZ;
        }
    }
}

