/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.graphics.gui;

import dnoved1.immersify.graphics.GraphicsHelper;
import dnoved1.immersify.graphics.gui.GuiTrace;
import dnoved1.immersify.graphics.gui.IClickableGui;
import dnoved1.immersify.graphics.gui.IRenderableGui;
import dnoved1.immersify.util.MathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public abstract class SelfOrientingGui
implements IClickableGui,
IRenderableGui {
    protected boolean horizontallyOrienting;
    protected boolean verticallyOrienting;
    protected double centerX;
    protected double centerY;
    protected double centerZ;

    protected SelfOrientingGui(boolean horizontallyOrienting, boolean verticallyOrienting, double centerX, double centerY, double centerZ) {
        this.horizontallyOrienting = horizontallyOrienting;
        this.verticallyOrienting = verticallyOrienting;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
    }

    protected void renderTextureInWorld(ResourceLocation textureLocation, Icon texture, boolean transparency, float width, float height) {
        GraphicsHelper.renderTextureInWorld(textureLocation, texture, transparency, this.centerX, this.centerY, this.centerZ, this.getHorizontalRotation(), this.getVerticalRotation(), width, height);
    }

    protected void renderTextureInWorld(ResourceLocation textureLocation, Icon texture, boolean transparency, float width, float height, float xOffset, float yOffset) {
        double xRotation = this.getHorizontalRotation() + 0.7853981633974483;
        double yRotation = this.getVerticalRotation();
        GraphicsHelper.renderTextureInWorld(textureLocation, texture, transparency, this.centerX + (double)(xOffset * MathHelper.cos(xRotation) + xOffset * MathHelper.sin(xRotation)) * 0.7, this.centerY, this.centerZ + (double)(xOffset * MathHelper.cos(xRotation) - xOffset * MathHelper.sin(xRotation)) * 0.7, this.getHorizontalRotation(), this.getVerticalRotation(), width, height);
    }

    protected void renderItemInWorld(ItemStack is, float size, int age, float partialTick) {
        GraphicsHelper.renderItemInWorld(is, size, age, this.centerX, this.centerY, this.centerZ, partialTick, this.getHorizontalRotation(), this.getVerticalRotation());
    }

    protected void renderItemInWorld(ItemStack is, float size, int age, float partialTick, float xOffset, float yOffset) {
        double xRotation = this.getHorizontalRotation() + 0.7853981633974483;
        double yRotation = this.getVerticalRotation();
        GraphicsHelper.renderItemInWorld(is, size, age, this.centerX + (double)(xOffset * MathHelper.cos(xRotation) + xOffset * MathHelper.sin(xRotation)) * 0.7, this.centerY, this.centerZ + (double)(xOffset * MathHelper.cos(xRotation) - xOffset * MathHelper.sin(xRotation)) * 0.7, partialTick, xRotation, yRotation);
    }

    protected void renderStringInWorld(String string, int color, int xOffset, int yOffset, float zOffset, float size) {
        GraphicsHelper.renderStringInWorld(string, color, this.centerX, this.centerY, this.centerZ, size, this.getHorizontalRotation(), this.getVerticalRotation(), xOffset, yOffset, zOffset);
    }

    @Override
    public Vec3 getPointOnPlane() {
        return Vec3.func_72443_a((double)this.centerX, (double)this.centerY, (double)this.centerZ);
    }

    @Override
    public Vec3 getNormalVector() {
        double z;
        double x;
        EntityLivingBase observer = Minecraft.func_71410_x().field_71451_h;
        if (this.horizontallyOrienting) {
            x = observer.field_70165_t - this.centerX;
            z = observer.field_70161_v - this.centerZ;
        } else {
            x = this.centerX;
            z = this.centerZ;
        }
        double y = this.verticallyOrienting ? observer.field_70163_u - this.centerY : this.centerY;
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    protected double getHorizontalRotation() {
        if (this.horizontallyOrienting) {
            EntityLivingBase observer = Minecraft.func_71410_x().field_71451_h;
            return Math.atan2(observer.field_70165_t - this.centerX, observer.field_70161_v - this.centerZ);
        }
        return 0.0;
    }

    protected double getVerticalRotation() {
        if (this.verticallyOrienting) {
            EntityLivingBase observer = Minecraft.func_71410_x().field_71451_h;
            return Math.atan2(Math.sqrt(Math.pow(observer.field_70161_v - this.centerZ, 2.0) + Math.pow(observer.field_70165_t - this.centerX, 2.0)), observer.field_70163_u - this.centerY) + 1.5707963267948966;
        }
        return 0.0;
    }

    protected GuiTrace rotateTraceOffsets(GuiTrace guiTrace) {
        float radiansX = (float)this.getHorizontalRotation();
        double horizontalOffset = this.horizontallyOrienting ? guiTrace.xOffset * (double)MathHelper.cos(radiansX) - guiTrace.zOffset * (double)MathHelper.sin(radiansX) : guiTrace.xOffset;
        double verticalOffset = this.verticallyOrienting ? -guiTrace.yOffset / (double)MathHelper.cos(this.getVerticalRotation()) : guiTrace.yOffset;
        return new GuiTrace(guiTrace.gui, horizontalOffset, verticalOffset, 0.0);
    }
}

