/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.api.property;

import net.minecraft.nbt.NBTBase;

public abstract class Property<T>
implements Comparable<Property<T>> {
    private final String name;
    private final T value;
    private final int compareCode;

    public Property(String name, T value) {
        this(name, value, 0);
    }

    public Property(String name, T value, int comparable) {
        this.name = name;
        this.value = value;
        this.compareCode = comparable;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public int getCompareType() {
        return this.compareCode;
    }

    public boolean matchesType(Property p) {
        if (!this.name.equals(p.getName())) {
            return false;
        }
        T otherValue = p.getValue();
        if (this.value == null && otherValue == null) {
            return true;
        }
        if (this.value == null || otherValue == null) {
            return false;
        }
        return this.value.getClass() == otherValue.getClass();
    }

    public boolean matches(Property p) {
        return this.name.equals(p.getName()) && p.getCompareType() == this.compareTo(p);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property p = (Property)o;
        if (!this.matchesType(p)) {
            return false;
        }
        return this.getName().equals(p.getName());
    }

    @Override
    public int compareTo(Property<T> p) {
        return -2;
    }

    public abstract NBTBase convertToNBT();

    public Object reconstructObject() {
        return this.getValue();
    }

    public static enum PropertyCommand {
        ADD,
        REMOVE,
        REPLACE,
        UNKNOWN;

    }

    public static enum PropertyType {
        INGREDIENT,
        TOOL,
        HEAT,
        UNKNOWN;

    }
}

