/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import dnoved1.immersify.ItemBackpack;
import dnoved1.immersify.PlacedItem;
import dnoved1.immersify.Proxy;
import dnoved1.immersify.api.CustomPacket;
import dnoved1.immersify.api.IPacketReceiver;
import dnoved1.immersify.entity.EntityCampfire;
import dnoved1.immersify.entity.EntityPlacedItem;
import dnoved1.immersify.graphics.ChestRenderer;
import dnoved1.immersify.util.EnumBlockSide;
import dnoved1.immersify.util.UtilMethods;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.IEventListener;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@Mod(modid="dnRedux", name="Redux", version="0.0.1")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class Redux
implements IEventListener,
IPacketReceiver {
    public static final String ID = "dnRedux";
    public static final String NAME = "Redux";
    public static final String VERSION = "0.0.1";
    private static final int ITEM_BACKPACK_ITEM_ID = 1000;
    private static final int ENTITY_PLACED_ITEM_ID = 1;
    private static final int ENTITY_CAMPFIRE_ID = 2;
    private static final String ITEM_BACKPACK_NAME = "dnBackpack";
    private static final String ENTITY_PLACED_ITEM_NAME = "dnEntityPlacedItem";
    private static final String ENTITY_CAMPFIRE_NAME = "dnCampfire";
    public static final String PACKET_ADD_ITEM_NAME = "Add Item";
    public static final String PACKET_REMOVE_ITEM_NAME = "Remove Item";
    public static final String PACKET_RIGHTCLICK_BLOCK_NAME = "Click Block";
    public static final String PACKET_REQUEST_CHEST_INVENTORY = "Request Chest Inventory";
    public static final String PACKET_SEND_CHEST_INVENTORY = "Send Chest Inventory";
    public static final String PACKET_SEND_BUTTON_CLICK = "Send Button Click";
    @Mod.Instance(value="dnRedux")
    public static Redux INSTANCE = new Redux();
    @SidedProxy(clientSide="dnoved1.immersify.ProxyClient", serverSide="dnoved1.immersify.Proxy")
    public static Proxy PROXY;
    public static ItemBackpack BACKPACK;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        BACKPACK = new ItemBackpack(1000, 0);
        GameRegistry.registerItem((Item)BACKPACK, (String)ITEM_BACKPACK_NAME);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        EntityRegistry.registerModEntity(EntityPlacedItem.class, (String)ENTITY_PLACED_ITEM_NAME, (int)1, (Object)INSTANCE, (int)32, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntityCampfire.class, (String)ENTITY_CAMPFIRE_NAME, (int)2, (Object)INSTANCE, (int)32, (int)5, (boolean)false);
        PROXY.registerEntityRenderers();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        CustomPacket.registerPacketName(INSTANCE, PACKET_ADD_ITEM_NAME);
        CustomPacket.registerPacketName(INSTANCE, PACKET_REMOVE_ITEM_NAME);
        CustomPacket.registerPacketName(INSTANCE, PACKET_RIGHTCLICK_BLOCK_NAME);
        CustomPacket.registerPacketName(INSTANCE, PACKET_REQUEST_CHEST_INVENTORY);
        CustomPacket.registerPacketName(INSTANCE, PACKET_SEND_CHEST_INVENTORY);
        CustomPacket.registerPacketName(INSTANCE, PACKET_SEND_BUTTON_CLICK);
    }

    @ForgeSubscribe
    public void invoke(Event event) {
        if (event instanceof PlayerInteractEvent) {
            PlayerInteractEvent pie = (PlayerInteractEvent)event;
            if (pie.entityPlayer.field_70170_p.field_72995_K && pie.entityPlayer.field_70170_p.func_72798_a(pie.x, pie.y, pie.z) == Block.field_72077_au.field_71990_ca) {
                pie.setCanceled(true);
                TileEntity te = pie.entityPlayer.field_70170_p.func_72796_p(pie.x, pie.y, pie.z);
                if (te != null && te instanceof TileEntityChest) {
                    TileEntityChest teChest = (TileEntityChest)te;
                    if (teChest.field_70427_h > 0) {
                        teChest.func_70305_f();
                    } else {
                        teChest.func_70295_k_();
                    }
                }
            }
            if (pie.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && pie.entityPlayer.field_70170_p.field_72995_K && pie.entityPlayer.func_70093_af() && pie.entityPlayer.func_71045_bC() != null) {
                try {
                    ByteArrayOutputStream packetData = new ByteArrayOutputStream();
                    DataOutputStream data = new DataOutputStream(packetData);
                    data.writeInt(pie.x);
                    data.writeByte(pie.y);
                    data.writeInt(pie.z);
                    data.writeByte(pie.face);
                    data.writeInt(pie.entityPlayer.field_70157_k);
                    CustomPacket packet = new CustomPacket(PACKET_RIGHTCLICK_BLOCK_NAME, packetData.toByteArray());
                    Minecraft.func_71410_x().func_71391_r().func_72552_c((Packet)packet);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                pie.setCanceled(true);
            }
        }
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            if (me.button == 0 && ChestRenderer.consumeLeftClick(me)) {
                me.setCanceled(true);
            }
        }
    }

    @Override
    public void receivePacket(NetHandler handler, CustomPacket packet) {
        if (packet.getName().equals(PACKET_ADD_ITEM_NAME)) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.getData()));
            try {
                int entityID = data.readInt();
                float rotation = data.readFloat();
                float xOffset = data.readFloat();
                float zOffset = data.readFloat();
                ItemStack is = Packet.func_73276_c((DataInput)data);
                EntityPlacedItem e = (EntityPlacedItem)handler.getPlayer().field_70170_p.func_73045_a(entityID);
                e.add(new PlacedItem(is, rotation, xOffset, zOffset));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (packet.getName().equals(PACKET_REMOVE_ITEM_NAME)) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.getData()));
            try {
                int entityID = data.readInt();
                byte i = data.readByte();
                EntityPlacedItem e = (EntityPlacedItem)handler.getPlayer().field_70170_p.func_73045_a(entityID);
                e.remove(i);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (packet.getName().equals(PACKET_RIGHTCLICK_BLOCK_NAME)) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.getData()));
            try {
                int x = data.readInt();
                byte y = data.readByte();
                int z = data.readInt();
                byte side = data.readByte();
                int playerID = data.readInt();
                EntityPlayer player = (EntityPlayer)handler.getPlayer().field_70170_p.func_73045_a(playerID);
                this.rightClickBlock(x, y, z, side, player);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (packet.getName().equals(PACKET_REQUEST_CHEST_INVENTORY)) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.getData()));
            try {
                int x = data.readInt();
                byte y = data.readByte();
                int z = data.readInt();
                int playerID = data.readInt();
                ChestRenderer.serverSendChestInventory(playerID, x, y, z);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (packet.getName().equals(PACKET_SEND_CHEST_INVENTORY)) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.getData()));
            try {
                int x = data.readInt();
                byte y = data.readByte();
                int z = data.readInt();
                while (data.available() > 0) {
                    byte slot = data.readByte();
                    ItemStack is = Packet.func_73276_c((DataInput)data);
                    ChestRenderer.clientRecieveChestSlot(slot, is);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (packet.getName().equals(PACKET_SEND_BUTTON_CLICK)) {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.getData()));
            try {
                int x = data.readInt();
                byte y = data.readByte();
                int z = data.readInt();
                int playerID = data.readInt();
                byte button = data.readByte();
                byte slot = data.readByte();
                ChestRenderer.serverRecieveButtonClick(x, y, z, playerID, button, slot);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void rightClickBlock(int x, int y, int z, int side, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        switch (EnumBlockSide.getSideFromInt(side)) {
            case TOP: {
                ++y;
                break;
            }
            case BOTTOM: {
                --y;
                break;
            }
            case NORTH: {
                --z;
                break;
            }
            case SOUTH: {
                ++z;
                break;
            }
            case EAST: {
                ++x;
                break;
            }
            case WEST: {
                --x;
                break;
            }
        }
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem != null) {
            ItemStack placedItem = ItemStack.func_77944_b((ItemStack)heldItem);
            placedItem.field_77994_a = 1;
            MovingObjectPosition mop = UtilMethods.getMovingObjectPositionFromPlayer(player, false);
            EntityPlacedItem item = new EntityPlacedItem(player.field_70170_p, (double)x + 0.5, y, (double)z + 0.5, new PlacedItem(placedItem, player.field_70759_as, (float)mop.field_72307_f.field_72450_a - (float)x - 0.5f, (float)mop.field_72307_f.field_72449_c - (float)z - 0.5f));
            player.field_70170_p.func_72838_d((Entity)item);
            --heldItem.field_77994_a;
            if (heldItem.field_77994_a <= 0) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
            }
        }
    }
}

