/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.graphics;

import dnoved1.immersify.api.CustomPacket;
import dnoved1.immersify.util.UtilMethods;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.MouseEvent;
import org.lwjgl.opengl.GL11;

public class ChestRenderer {
    private static Tessellator tessellator = Tessellator.field_78398_a;
    public static RenderItem itemRenderer = new RenderItem();
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    private static final int WIDGETS_TEXTURE_LENGTH = 256;
    private static final int HOTBAR_START_X = 1;
    private static final int HOTBAR_WIDTH = 60;
    private static final int HOTBAR_START_Y = 1;
    private static final int HOTBAR_HEIGHT = 20;
    private static final float HOTBAR_LEFT_X = 0.00390625f;
    private static final float HOTBAR_RIGHT_X = 0.23828125f;
    private static final float HOTBAR_TOP_Y = 0.00390625f;
    private static final float HOTBAR_BOTTOM_Y = 0.08203125f;
    private static final float SIZE = 0.01f;
    private static final float SIZE_X = 0.59999996f;
    private static final float SIZE_Y = 0.19999999f;
    private static Vec3[] squarePoints = new Vec3[4];
    private static final ResourceLocation ASCII_TEXTURE = new ResourceLocation("textures/font/ascii.png");
    private static final int ASCII_TEXTURE_LENGTH = 128;
    private static final int ARROW_RIGHT_START_X = 0;
    private static final int ARROW_RIGHT_WIDTH = 8;
    private static final int ARROW_RIGHT_START_Y = 8;
    private static final int ARROW_RIGHT_HEIGHT = 8;
    private static final float ARROW_RIGHT_LEFT_X = 0.0f;
    private static final float ARROW_RIGHT_RIGHT_X = 0.0625f;
    private static final float ARROW_RIGHT_TOP_Y = 0.0625f;
    private static final float ARROW_RIGHT_BOTTOM_Y = 0.125f;
    private static final int ARROW_LEFT_START_X = 8;
    private static final int ARROW_LEFT_WIDTH = 8;
    private static final int ARROW_LEFT_START_Y = 8;
    private static final int ARROW_LEFT_HEIGHT = 8;
    private static final float ARROW_LEFT_LEFT_X = 0.0625f;
    private static final float ARROW_LEFT_RIGHT_X = 0.125f;
    private static final float ARROW_LEFT_TOP_Y = 0.0625f;
    private static final float ARROW_LEFT_BOTTOM_Y = 0.125f;
    private static final byte BUTTON_LEFT_ARROW = 0;
    private static final byte BUTTON_RIGHT_ARROW = 1;
    private static final byte BUTTON_LEFT_SLOT = 2;
    private static final byte BUTTON_MIDDLE_SLOT = 3;
    private static final byte BUTTON_RIGHT_SLOT = 4;
    private static long leftClickCounter = 0L;
    public static ChestRenderer currentRenderer;
    private int chestX;
    private int chestY;
    private int chestZ;
    private ItemStack[] currentContents = new ItemStack[27];
    private int itemOffset;

    public ChestRenderer(int x, int y, int z) {
        this.chestX = x;
        this.chestY = y;
        this.chestZ = z;
        this.itemOffset = 0;
        this.clientRequestInventory(x, y, z);
    }

    public static void renderChest(TileEntityChest teChest) {
        if (currentRenderer == null || !currentRenderer.sameChestRenderer(teChest.field_70329_l, teChest.field_70330_m, teChest.field_70327_n)) {
            currentRenderer = new ChestRenderer(teChest.field_70329_l, teChest.field_70330_m, teChest.field_70327_n);
        }
        currentRenderer.renderChest_do();
    }

    private void renderChest_do() {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (Minecraft.func_71410_x().field_71441_e.func_72796_p(this.chestX, this.chestY, this.chestZ) instanceof TileEntityChest && ((TileEntityChest)Minecraft.func_71410_x().field_71441_e.func_72796_p((int)this.chestX, (int)this.chestY, (int)this.chestZ)).field_70427_h > 0) {
            EntityClientPlayerMP observer = Minecraft.func_71410_x().field_71439_g;
            double guiRotationRadians = Math.atan2(observer.field_70165_t - (double)this.chestX - 0.5, observer.field_70161_v - (double)this.chestZ - 0.5);
            float xOffset = (float)((double)this.chestX - TileEntityRenderer.field_76961_b);
            float yOffset = (float)((double)this.chestY - TileEntityRenderer.field_76962_c);
            float zOffset = (float)((double)this.chestZ - TileEntityRenderer.field_76959_d);
            GL11.glTranslatef((float)(xOffset + 0.5f), (float)(yOffset + 1.5f), (float)(zOffset + 0.5f));
            GL11.glRotatef((float)((float)(guiRotationRadians * 57.29577951308232)), (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS_TEXTURE);
            tessellator.func_78382_b();
            tessellator.func_78374_a(ChestRenderer.squarePoints[0].field_72450_a * 0.5999999642372131, ChestRenderer.squarePoints[0].field_72448_b * 0.19999998807907104, ChestRenderer.squarePoints[0].field_72449_c * 0.5999999642372131, 0.00390625, 0.00390625);
            tessellator.func_78374_a(ChestRenderer.squarePoints[1].field_72450_a * 0.5999999642372131, ChestRenderer.squarePoints[1].field_72448_b * 0.19999998807907104, ChestRenderer.squarePoints[1].field_72449_c * 0.5999999642372131, 0.23828125, 0.00390625);
            tessellator.func_78374_a(ChestRenderer.squarePoints[2].field_72450_a * 0.5999999642372131, ChestRenderer.squarePoints[2].field_72448_b * 0.19999998807907104, ChestRenderer.squarePoints[2].field_72449_c * 0.5999999642372131, 0.23828125, 0.08203125);
            tessellator.func_78374_a(ChestRenderer.squarePoints[3].field_72450_a * 0.5999999642372131, ChestRenderer.squarePoints[3].field_72448_b * 0.19999998807907104, ChestRenderer.squarePoints[3].field_72449_c * 0.5999999642372131, 0.00390625, 0.08203125);
            tessellator.func_78381_a();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ASCII_TEXTURE);
            float horizontalOffset = -1.0f;
            float sizeOffset = 0.2f;
            GL11.glColor3f((float)0.5f, (float)0.0f, (float)1.0f);
            tessellator.func_78382_b();
            tessellator.func_78374_a(ChestRenderer.squarePoints[0].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[0].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[0].field_72449_c * (double)sizeOffset, 0.0, 0.0625);
            tessellator.func_78374_a(ChestRenderer.squarePoints[1].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[1].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[1].field_72449_c * (double)sizeOffset, 0.0625, 0.0625);
            tessellator.func_78374_a(ChestRenderer.squarePoints[2].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[2].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[2].field_72449_c * (double)sizeOffset, 0.0625, 0.125);
            tessellator.func_78374_a(ChestRenderer.squarePoints[3].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[3].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[3].field_72449_c * 0.5999999642372131, 0.0, 0.125);
            horizontalOffset = 1.0f;
            tessellator.func_78374_a(ChestRenderer.squarePoints[0].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[0].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[0].field_72449_c * (double)sizeOffset, 0.0625, 0.0625);
            tessellator.func_78374_a(ChestRenderer.squarePoints[1].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[1].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[1].field_72449_c * (double)sizeOffset, 0.125, 0.0625);
            tessellator.func_78374_a(ChestRenderer.squarePoints[2].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[2].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[2].field_72449_c * (double)sizeOffset, 0.125, 0.125);
            tessellator.func_78374_a(ChestRenderer.squarePoints[3].field_72450_a * (double)sizeOffset + (double)horizontalOffset, ChestRenderer.squarePoints[3].field_72448_b * (double)sizeOffset, ChestRenderer.squarePoints[3].field_72449_c * 0.5999999642372131, 0.0625, 0.125);
            tessellator.func_78381_a();
            GL11.glTranslatef((float)-0.175f, (float)0.175f, (float)0.01f);
            float sizeOffset2 = 0.02f;
            GL11.glScalef((float)sizeOffset2, (float)sizeOffset2, (float)sizeOffset2);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int i = -1; i < 2; ++i) {
                ItemStack is = this.currentContents[(this.itemOffset + 27 + i) % 27];
                if (is == null) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(i * 20), (float)0.0f, (float)0.0f);
                if (is.func_77973_b() instanceof ItemBlock && RenderBlocks.func_78597_b((int)Block.field_71973_m[is.field_77993_c].func_71857_b())) {
                    GL11.glTranslatef((float)(i * -2 + 1), (float)1.0f, (float)-15.0f);
                    float sizeOffset3 = 0.9f;
                    GL11.glScalef((float)sizeOffset3, (float)sizeOffset3, (float)sizeOffset3);
                }
                ChestRenderer.renderInventorySlot(is, 0, 0, 1.0f);
                GL11.glPopMatrix();
            }
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private static void renderInventorySlot(ItemStack is, int x, int y, float partialTick) {
        if (is != null) {
            float animations = (float)is.field_77992_b - partialTick;
            if (animations > 0.0f) {
                GL11.glPushMatrix();
                float animations2 = 1.0f + animations / 5.0f;
                GL11.glTranslatef((float)(x + 8), (float)(y + 12), (float)0.0f);
                GL11.glScalef((float)(1.0f / animations2), (float)((animations2 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(x + 8)), (float)(-(y + 12)), (float)0.0f);
            }
            itemRenderer.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), is, x, y);
            if (animations > 0.0f) {
                GL11.glPopMatrix();
            }
            itemRenderer.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), is, x, y);
        }
    }

    public boolean sameChestRenderer(int x, int y, int z) {
        return x == this.chestX && y == this.chestY && z == this.chestZ;
    }

    public static boolean consumeLeftClick(MouseEvent me) {
        if (!ChestRenderer.enoughTimePassedSinceClick() || currentRenderer == null || !(Minecraft.func_71410_x().field_71441_e.func_72796_p(ChestRenderer.currentRenderer.chestX, ChestRenderer.currentRenderer.chestY, ChestRenderer.currentRenderer.chestZ) instanceof TileEntityChest) || ((TileEntityChest)Minecraft.func_71410_x().field_71441_e.func_72796_p((int)ChestRenderer.currentRenderer.chestX, (int)ChestRenderer.currentRenderer.chestY, (int)ChestRenderer.currentRenderer.chestZ)).field_70427_h <= 0) {
            return false;
        }
        return currentRenderer.consumeLeftClick_do(me);
    }

    private boolean consumeLeftClick_do(MouseEvent me) {
        EntityClientPlayerMP observer = Minecraft.func_71410_x().field_71439_g;
        double rotationGuiRadians = Math.atan2(observer.field_70165_t - (double)this.chestX - 0.5, observer.field_70161_v - (double)this.chestZ - 0.5);
        float length = 2.0f;
        double Ld2 = length / 2.0f;
        double xzDelta = Math.sqrt(Math.pow(observer.field_70165_t - (double)this.chestX - 0.5, 2.0) + Math.pow(observer.field_70161_v - (double)this.chestZ - 0.5, 2.0));
        double yDelta = observer.field_70163_u - (double)this.chestY - 1.53;
        double arrowButtonOffset = Math.atan2(Ld2, xzDelta);
        double needRotationXRight = -(rotationGuiRadians + Math.PI + arrowButtonOffset) * 57.29577951308232;
        double needRotationXLeft = -(rotationGuiRadians + Math.PI - arrowButtonOffset) * 57.29577951308232;
        double needRotationY = Math.atan2(yDelta, xzDelta) * 57.29577951308232;
        double marginOfError = 5.0;
        if (Math.abs((double)observer.field_70125_A - needRotationY) < marginOfError) {
            if (Math.abs(MathHelper.func_76138_g((double)((double)observer.field_70177_z - needRotationXRight))) < marginOfError) {
                this.itemOffset = (this.itemOffset + 26) % 27;
                leftClickCounter = Minecraft.func_71386_F();
                return true;
            }
            if (Math.abs(MathHelper.func_76138_g((double)((double)observer.field_70177_z - -(rotationGuiRadians + Math.PI + arrowButtonOffset / 2.0) * 57.29577951308232))) < marginOfError) {
                this.clientSendButtonClick((byte)2);
                leftClickCounter = Minecraft.func_71386_F();
                return true;
            }
            if (Math.abs(MathHelper.func_76138_g((double)((double)observer.field_70177_z - -(rotationGuiRadians + Math.PI) * 57.29577951308232))) < marginOfError) {
                this.clientSendButtonClick((byte)3);
                leftClickCounter = Minecraft.func_71386_F();
                return true;
            }
            if (Math.abs(MathHelper.func_76138_g((double)((double)observer.field_70177_z - -(rotationGuiRadians + Math.PI - arrowButtonOffset / 2.0) * 57.29577951308232))) < marginOfError) {
                this.clientSendButtonClick((byte)4);
                leftClickCounter = Minecraft.func_71386_F();
                return true;
            }
            if (Math.abs(MathHelper.func_76138_g((double)((double)observer.field_70177_z - needRotationXLeft))) < marginOfError) {
                this.itemOffset = (this.itemOffset + 1) % 27;
                leftClickCounter = Minecraft.func_71386_F();
                return true;
            }
        }
        return false;
    }

    private static boolean enoughTimePassedSinceClick() {
        return Minecraft.func_71386_F() - leftClickCounter > 150L;
    }

    private void clientRequestInventory(int x, int y, int z) {
        try {
            ByteArrayOutputStream packetData = new ByteArrayOutputStream();
            DataOutputStream packetWrite = new DataOutputStream(packetData);
            packetWrite.writeInt(x);
            packetWrite.writeByte(y);
            packetWrite.writeInt(z);
            packetWrite.writeInt(Minecraft.func_71410_x().field_71439_g.field_70157_k);
            CustomPacket packet = new CustomPacket("Request Chest Inventory", packetData.toByteArray());
            Minecraft.func_71410_x().func_71391_r().func_72552_c((Packet)packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void clientSendButtonClick(byte button) {
        try {
            ByteArrayOutputStream packetData = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(packetData);
            data.writeInt(this.chestX);
            data.writeByte(this.chestY);
            data.writeInt(this.chestZ);
            data.writeInt(Minecraft.func_71410_x().field_71439_g.field_70157_k);
            data.writeByte(button);
            data.writeByte(this.itemOffset);
            CustomPacket packet = new CustomPacket("Send Button Click", packetData.toByteArray());
            Minecraft.func_71410_x().func_71391_r().func_72552_c((Packet)packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void clientRecieveChestSlot(int slot, ItemStack is) {
        ChestRenderer.currentRenderer.currentContents[slot] = is;
    }

    public static void serverSendChestInventory(int playerID, int x, int y, int z) {
        WorldServer world;
        EntityPlayerMP player = null;
        WorldServer[] arr$ = MinecraftServer.func_71276_C().field_71305_c;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (player = (EntityPlayerMP)UtilMethods.getPlayerFromID((World)(world = arr$[i$]), playerID)) == null; ++i$) {
        }
        if (player == null) {
            System.out.println("Could not find player to send chest data to");
            return;
        }
        TileEntity te = player.field_70170_p.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityChest) {
            TileEntityChest teChest = (TileEntityChest)te;
            try {
                ByteArrayOutputStream packetData = new ByteArrayOutputStream();
                DataOutputStream packetWrite = new DataOutputStream(packetData);
                packetWrite.writeInt(x);
                packetWrite.writeByte(y);
                packetWrite.writeInt(z);
                for (int i = 0; i < teChest.func_70302_i_(); ++i) {
                    packetWrite.writeByte(i);
                    Packet.func_73270_a((ItemStack)teChest.func_70301_a(i), (DataOutput)packetWrite);
                }
                CustomPacket packet = new CustomPacket("Send Chest Inventory", packetData.toByteArray());
                player.field_71135_a.func_72567_b((Packet)packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void serverRecieveButtonClick(int x, int y, int z, int playerID, byte button, byte slot) {
        WorldServer world;
        switch (button) {
            case 2: {
                slot = (byte)(slot - 1);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                slot = (byte)(slot + 1);
                break;
            }
            default: {
                return;
            }
        }
        slot = (byte)((slot + 27) % 27);
        EntityPlayer player = null;
        WorldServer[] arr$ = MinecraftServer.func_71276_C().field_71305_c;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (player = UtilMethods.getPlayerFromID((World)(world = arr$[i$]), playerID)) == null; ++i$) {
        }
        if (player == null) {
            System.out.println("Could not find player for button click");
            return;
        }
        TileEntity te = player.field_70170_p.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityChest) {
            TileEntityChest teChest = (TileEntityChest)te;
            ItemStack is = teChest.func_70301_a((int)slot);
            ItemStack heldItem = player.func_71045_bC();
            if (player.func_70093_af()) {
                if (heldItem == null) {
                    return;
                }
                if (is == null) {
                    teChest.func_70299_a((int)slot, new ItemStack(heldItem.field_77993_c, 1, heldItem.func_77960_j()));
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                } else if (is.func_77969_a(heldItem)) {
                    ++is.field_77994_a;
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
            } else {
                if (is == null) {
                    return;
                }
                if (heldItem == null) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = new ItemStack(is.field_77993_c, 1, is.func_77960_j());
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        teChest.func_70299_a((int)slot, null);
                    }
                } else if (is.func_77969_a(player.func_71045_bC())) {
                    ++heldItem.field_77994_a;
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        teChest.func_70299_a((int)slot, null);
                    }
                } else {
                    teChest.field_70331_k.func_72838_d((Entity)new EntityItem(teChest.field_70331_k, (double)teChest.field_70329_l + 0.5, (double)teChest.field_70330_m + 1.5, (double)teChest.field_70327_n + 0.5, new ItemStack(is.field_77993_c, 1, is.func_77960_j())));
                    --is.field_77994_a;
                    if (is.field_77994_a <= 0) {
                        teChest.func_70299_a((int)slot, null);
                    }
                }
            }
            ChestRenderer.serverSendChestInventory(playerID, x, y, z);
        }
    }

    static {
        ChestRenderer.squarePoints[0] = Vec3.func_72443_a((double)1.0, (double)0.0, (double)-1.0);
        ChestRenderer.squarePoints[1] = Vec3.func_72443_a((double)1.0, (double)0.0, (double)1.0);
        ChestRenderer.squarePoints[2] = Vec3.func_72443_a((double)-1.0, (double)0.0, (double)1.0);
        ChestRenderer.squarePoints[3] = Vec3.func_72443_a((double)-1.0, (double)0.0, (double)-1.0);
        for (Vec3 squarePoint : squarePoints) {
            squarePoint.func_72440_a(-1.5707964f);
            squarePoint.func_72442_b((float)Math.PI);
            UtilMethods.rotateAroundZ(squarePoint, 1.5707964f);
        }
    }
}

