/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.api;

import dnoved1.immersify.api.IPacketReceiver;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;

public class CustomPacket
extends Packet {
    private static final int CUSTOM_PACKET_ID = 249;
    private static byte nextID = 0;
    private static HashMap<Byte, IPacketReceiver> ID_TO_RECEIVER = new HashMap();
    private static HashMap<String, Byte> NAME_TO_ID = new HashMap();
    private static HashMap<Byte, String> ID_TO_NAME = new HashMap();
    private byte packetID;
    private byte[] data;
    private int length;

    public CustomPacket(String name, byte[] data) {
        Byte id = NAME_TO_ID.get(name);
        if (id == null) {
            throw new Error("Packet name not registered");
        }
        this.packetID = id;
        this.data = data;
        this.length = data.length;
    }

    public void func_73267_a(DataInput datainput) throws IOException {
        this.packetID = datainput.readByte();
        this.length = datainput.readShort();
        this.data = new byte[this.length];
        datainput.readFully(this.data);
    }

    public void func_73273_a(DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(this.packetID);
        dataoutput.writeShort(this.length);
        dataoutput.write(this.data);
    }

    public void func_73279_a(NetHandler handler) {
        ID_TO_RECEIVER.get(this.packetID).receivePacket(handler, this);
    }

    public int func_73284_a() {
        return 3 + this.length;
    }

    public static void registerPacketName(IPacketReceiver owner, String name) {
        NAME_TO_ID.put(name, nextID);
        ID_TO_NAME.put(nextID, name);
        ID_TO_RECEIVER.put(nextID, owner);
        nextID = (byte)(nextID + 1);
    }

    public String getName() {
        return ID_TO_NAME.get(this.packetID);
    }

    public byte[] getData() {
        return this.data;
    }

    static {
        Packet.func_73285_a((int)249, (boolean)true, (boolean)true, CustomPacket.class);
    }
}

