/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify;

import dnoved1.immersify.api.property.Property;
import dnoved1.immersify.api.property.PropertyCompound;
import dnoved1.immersify.api.property.PropertyEmpty;
import dnoved1.immersify.api.property.PropertyNumber;
import dnoved1.immersify.util.UtilMethods;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PropertyItemStack
extends PropertyCompound<Property> {
    public static final String ITEM_ID_NAME = "Item ID";
    public static final String ITEM_METADATA_NAME = "Item Metadata";
    public static final String STACK_SIZE_NAME = "Stack Size";
    public static final String STACK_TAG_COMPOUND_NAME = "Stack Tag Compound";

    public PropertyItemStack(String name, ItemStack value) {
        super(name, (T[])PropertyItemStack.convertItemStackToProperty(value));
    }

    public PropertyItemStack(String name, ItemStack value, int comparable) {
        super(name, (T[])PropertyItemStack.convertItemStackToProperty(value), comparable);
    }

    @Override
    public Object reconstructObject() {
        return this.convertToItemStack();
    }

    private static Property[] convertItemStackToProperty(ItemStack is) {
        Property[] isData = new Property[]{new PropertyNumber<Short>(ITEM_ID_NAME, (short)is.field_77993_c), new PropertyNumber<Short>(ITEM_METADATA_NAME, (short)is.func_77960_j()), new PropertyNumber<Byte>(STACK_SIZE_NAME, (byte)is.field_77994_a), is.field_77990_d == null ? new PropertyEmpty(STACK_TAG_COMPOUND_NAME) : UtilMethods.convertNBTToProperty((NBTBase)is.field_77990_d)};
        return isData;
    }

    public ItemStack convertToItemStack() {
        Property[] myData = (Property[])this.getValue();
        int itemID = ((Short)((PropertyNumber)myData[0]).getValue()).intValue();
        int metadata = ((Short)((PropertyNumber)myData[1]).getValue()).intValue();
        int stackSize = ((Byte)((PropertyNumber)myData[2]).getValue()).intValue();
        NBTTagCompound stackTagCompound = (NBTTagCompound)(myData[3].getValue() == null ? null : myData[3].convertToNBT());
        ItemStack is = new ItemStack(itemID, stackSize, metadata);
        is.field_77990_d = stackTagCompound;
        return is;
    }
}

