/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import dnoved1.immersify.PlacedItem;
import dnoved1.immersify.PropertyItemStack;
import dnoved1.immersify.PropertyTool;
import dnoved1.immersify.api.CustomPacket;
import dnoved1.immersify.api.IRecipe;
import dnoved1.immersify.api.IRecipeCaller;
import dnoved1.immersify.api.property.Property;
import dnoved1.immersify.entity.EntityCampfire;
import dnoved1.immersify.entity.EntityEmpty;
import dnoved1.immersify.recipe.RecipeManager;
import dnoved1.immersify.recipe.ShapingRecipe;
import dnoved1.immersify.util.EnumMouseClick;
import dnoved1.immersify.util.UtilMethods;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityPlacedItem
extends EntityEmpty
implements IRecipeCaller,
IEntityAdditionalSpawnData {
    public static final float ENTITY_WIDTH = 0.85f;
    public static final float ENTITY_HEIGHT = 0.1f;
    private static final String NBT_ITEMS = "Items";
    private static final String NBT_POSISTION = "Pos";
    public static final String SPAWN_CAMPFIRE_COMMAND = "SPAWN CAMPFIRE";
    private ArrayList<PlacedItem> placedItems = new ArrayList();

    public EntityPlacedItem(World world, double x, double y, double z, PlacedItem ... items) {
        super(world);
        if (items.length == 0) {
            this.func_70106_y();
        }
        this.func_70107_b(x, y, z);
        for (int i = 0; i < items.length; ++i) {
            this.placedItems.add(items[i]);
        }
    }

    public EntityPlacedItem(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        this.func_70105_a(0.85f, 0.1f);
    }

    @Override
    public void func_70020_e(NBTTagCompound nbtRead) {
        NBTTagList posistion = nbtRead.func_74761_m(NBT_POSISTION);
        this.field_70165_t = ((NBTTagDouble)posistion.func_74743_b((int)0)).field_74755_a;
        this.field_70163_u = ((NBTTagDouble)posistion.func_74743_b((int)1)).field_74755_a;
        this.field_70161_v = ((NBTTagDouble)posistion.func_74743_b((int)2)).field_74755_a;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        NBTTagList items = nbtRead.func_74761_m(NBT_ITEMS);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            this.placedItems.add(PlacedItem.readFromNBT((NBTTagCompound)items.func_74743_b(i)));
        }
        if (this.placedItems.size() == 0) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70109_d(NBTTagCompound nbtWrite) {
        nbtWrite.func_74782_a(NBT_POSISTION, (NBTBase)this.func_70087_a(new double[]{this.field_70165_t, this.field_70163_u, this.field_70161_v}));
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.placedItems.size(); ++i) {
            items.func_74742_a((NBTBase)this.placedItems.get(i).writeToNBT(null));
        }
        nbtWrite.func_74782_a(NBT_ITEMS, (NBTBase)items);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            PlacedItem lastItem = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, lastItem.getItemStack());
            this.field_70170_p.func_72838_d((Entity)entityItem);
            if (damageSource.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)damageSource.func_76346_g();
                this.clickEntity(player.func_71045_bC(), player, EnumMouseClick.LEFT);
            }
        }
        return false;
    }

    public boolean func_130002_c(EntityPlayer player) {
        ItemStack is = player.func_71045_bC();
        if (player.func_70093_af() && is != null && !this.field_70170_p.field_72995_K) {
            ItemStack isCopy = ItemStack.func_77944_b((ItemStack)is);
            isCopy.field_77994_a = 1;
            MovingObjectPosition mop = UtilMethods.getMovingObjectPositionFromPlayer(player, false);
            this.add(new PlacedItem(isCopy, player.field_70759_as, (float)mop.field_72307_f.field_72450_a - (float)Math.floor(mop.field_72307_f.field_72450_a) - 0.5f, (float)mop.field_72307_f.field_72449_c - (float)Math.floor(mop.field_72307_f.field_72449_c) - 0.5f));
            --is.field_77994_a;
            if (is.field_77994_a <= 0) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
            }
            this.clickEntity(is, player, EnumMouseClick.RIGHT);
        }
        return false;
    }

    private void clickEntity(ItemStack toolApplied, EntityPlayer player, EnumMouseClick mouseClick) {
        IRecipe recipe;
        boolean applyTool = mouseClick == EnumMouseClick.LEFT && player.func_70093_af();
        Property[] properties = new Property[this.size() + (applyTool ? 1 : 0)];
        for (int i = 0; i < this.size(); ++i) {
            properties[i] = new PropertyItemStack(Property.PropertyType.INGREDIENT.toString(), this.get(i).getItemStack());
        }
        if (applyTool) {
            properties[this.size()] = new PropertyTool(Property.PropertyType.TOOL.toString(), toolApplied);
        }
        if ((recipe = RecipeManager.getFirstMatchingRecipe(properties)) != null) {
            recipe.onCrafted(this);
            if (recipe instanceof ShapingRecipe && toolApplied != null) {
                toolApplied.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        this.checkIfStillValid();
    }

    public void checkIfStillValid() {
        if (this.placedItems.size() == 0) {
            this.func_70106_y();
        }
    }

    public void addEntityPlacedItem(EntityPlacedItem otherItem) {
        for (int i = 0; i < otherItem.size(); ++i) {
            this.add(otherItem.get(i));
        }
    }

    public int size() {
        return this.placedItems.size();
    }

    public boolean add(PlacedItem item) {
        this.placedItems.add(item);
        if (!this.field_70170_p.field_72995_K) {
            try {
                ByteArrayOutputStream packetData = new ByteArrayOutputStream();
                DataOutputStream packetWrite = new DataOutputStream(packetData);
                packetWrite.writeInt(this.field_70157_k);
                packetWrite.writeFloat(item.getRotation());
                packetWrite.writeFloat(item.getXOffset());
                packetWrite.writeFloat(item.getZOffset());
                Packet.func_73270_a((ItemStack)item.getItemStack(), (DataOutput)packetWrite);
                CustomPacket packet = new CustomPacket("Add Item", packetData.toByteArray());
                ((WorldServer)this.field_70170_p).func_73039_n().func_72784_a((Entity)this, (Packet)packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean remove(PlacedItem item) {
        for (int i = 0; i < this.placedItems.size(); ++i) {
            if (!this.placedItems.get(i).equals(item)) continue;
            this.placedItems.remove(i);
            if (!this.field_70170_p.field_72995_K) {
                try {
                    ByteArrayOutputStream packetData = new ByteArrayOutputStream();
                    DataOutputStream packetWrite = new DataOutputStream(packetData);
                    packetWrite.writeInt(this.field_70157_k);
                    packetWrite.writeByte(i);
                    CustomPacket packet = new CustomPacket("Remove Item", packetData.toByteArray());
                    ((WorldServer)this.field_70170_p).func_73039_n().func_72784_a((Entity)this, (Packet)packet);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public boolean remove(int index) {
        if (index > this.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.placedItems.remove(index);
        if (!this.field_70170_p.field_72995_K) {
            try {
                ByteArrayOutputStream packetData = new ByteArrayOutputStream();
                DataOutputStream packetWrite = new DataOutputStream(packetData);
                packetWrite.writeInt(this.field_70157_k);
                packetWrite.writeByte(index);
                CustomPacket packet = new CustomPacket("Remove Item", packetData.toByteArray());
                ((WorldServer)this.field_70170_p).func_73039_n().func_72784_a((Entity)this, (Packet)packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public PlacedItem get(int index) {
        if (index > this.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.placedItems.get(index);
    }

    public boolean clear() {
        this.placedItems.clear();
        return true;
    }

    @Override
    public void recieveData(Property ... data) {
        for (Property datum : data) {
            String command = datum.getName();
            Object containedObject = datum.reconstructObject();
            if (command.equals(Property.PropertyCommand.ADD.toString()) && containedObject instanceof ItemStack) {
                EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ItemStack)containedObject);
                this.field_70170_p.func_72838_d((Entity)entityItem);
            }
            if (command.equals(Property.PropertyCommand.ADD.toString()) && datum.getValue().equals(SPAWN_CAMPFIRE_COMMAND)) {
                EntityCampfire campfire = new EntityCampfire(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)campfire);
            }
            if (command.equals(Property.PropertyCommand.REMOVE.toString()) && containedObject instanceof ItemStack) {
                for (int i = 0; i < this.placedItems.size(); ++i) {
                    if (!ItemStack.func_77989_b((ItemStack)this.placedItems.get(i).getItemStack(), (ItemStack)((ItemStack)containedObject))) continue;
                    this.remove(i);
                    break;
                }
            }
            if (!command.equals(Property.PropertyCommand.REPLACE.toString()) || !(containedObject instanceof ItemStack)) continue;
            float newRotation = 0.0f;
            for (int i = 0; i < this.size(); ++i) {
                newRotation += this.get(i).getRotation();
            }
            this.clear();
            this.add(new PlacedItem((ItemStack)containedObject, newRotation /= (float)this.size()));
        }
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        try {
            data.writeByte(this.size());
            for (int i = 0; i < this.size(); ++i) {
                Packet.func_73270_a((ItemStack)this.get(i).getItemStack(), (DataOutput)data);
                data.writeFloat(this.get(i).getRotation());
                data.writeFloat(this.get(i).getXOffset());
                data.writeFloat(this.get(i).getZOffset());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            int size = data.readByte();
            for (int i = 0; i < size; ++i) {
                ItemStack is = Packet.func_73276_c((DataInput)data);
                float rotation = data.readFloat();
                float xOffset = data.readFloat();
                float zOffset = data.readFloat();
                this.add(new PlacedItem(is, rotation, xOffset, zOffset));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

