/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.util;

import dnoved1.immersify.api.property.Property;
import dnoved1.immersify.api.property.PropertyCompound;
import dnoved1.immersify.api.property.PropertyEmpty;
import dnoved1.immersify.api.property.PropertyNumber;
import dnoved1.immersify.api.property.PropertyString;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class UtilMethods {
    public static Property convertNBTToProperty(NBTBase nbt) {
        if (nbt instanceof NBTTagByte) {
            return new PropertyNumber<Byte>(nbt.func_74740_e(), ((NBTTagByte)nbt).field_74756_a);
        }
        if (nbt instanceof NBTTagByteArray) {
            byte[] pBytes = ((NBTTagByteArray)nbt).field_74754_a;
            Byte[] oBytes = new Byte[pBytes.length];
            for (int i = 0; i < pBytes.length; ++i) {
                oBytes[i] = pBytes[i];
            }
            return new PropertyCompound<Byte>(nbt.func_74740_e(), oBytes);
        }
        if (nbt instanceof NBTTagCompound) {
            Collection tags = ((NBTTagCompound)nbt).func_74758_c();
            if (tags.size() == 0) {
                return null;
            }
            if (tags.size() == 1) {
                return UtilMethods.convertNBTToProperty((NBTBase)tags.iterator().next());
            }
            ArrayList<Property> propertyList = new ArrayList<Property>();
            for (NBTBase tag : tags) {
                propertyList.add(UtilMethods.convertNBTToProperty(tag));
            }
            return new PropertyCompound(nbt.func_74740_e(), propertyList.toArray((T[])null));
        }
        if (nbt instanceof NBTTagDouble) {
            return new PropertyNumber<Double>(nbt.func_74740_e(), ((NBTTagDouble)nbt).field_74755_a);
        }
        if (nbt instanceof NBTTagEnd) {
            return new PropertyEmpty(nbt.func_74740_e());
        }
        if (nbt instanceof NBTTagFloat) {
            return new PropertyNumber<Float>(nbt.func_74740_e(), Float.valueOf(((NBTTagFloat)nbt).field_74750_a));
        }
        if (nbt instanceof NBTTagInt) {
            return new PropertyNumber<Integer>(nbt.func_74740_e(), ((NBTTagInt)nbt).field_74748_a);
        }
        if (nbt instanceof NBTTagIntArray) {
            int[] pInts = ((NBTTagIntArray)nbt).field_74749_a;
            Integer[] oInts = new Integer[pInts.length];
            for (int i = 0; i < pInts.length; ++i) {
                oInts[i] = pInts[i];
            }
            return new PropertyCompound<Integer>(nbt.func_74740_e(), oInts);
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList tagList = (NBTTagList)nbt;
            if (tagList.func_74745_c() == 0) {
                return null;
            }
            if (tagList.func_74745_c() == 1) {
                return UtilMethods.convertNBTToProperty(tagList.func_74743_b(0));
            }
            ArrayList<Property> propertyList = new ArrayList<Property>();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                propertyList.add(UtilMethods.convertNBTToProperty(tagList.func_74743_b(i)));
            }
            return new PropertyCompound(nbt.func_74740_e(), propertyList.toArray((T[])null));
        }
        if (nbt instanceof NBTTagLong) {
            return new PropertyNumber<Long>(nbt.func_74740_e(), ((NBTTagLong)nbt).field_74753_a);
        }
        if (nbt instanceof NBTTagShort) {
            return new PropertyNumber<Short>(nbt.func_74740_e(), ((NBTTagShort)nbt).field_74752_a);
        }
        if (nbt instanceof NBTTagString) {
            return new PropertyString(nbt.func_74740_e(), ((NBTTagString)nbt).field_74751_a);
        }
        return null;
    }

    public static void rotateAroundZ(Vec3 point, float rotation) {
        float f = MathHelper.func_76134_b((float)rotation);
        float f1 = MathHelper.func_76126_a((float)rotation);
        double d = point.field_72450_a * (double)f + point.field_72448_b * (double)f1;
        double d1 = point.field_72448_b * (double)f - point.field_72450_a * (double)f1;
        double d2 = point.field_72449_c;
        point.field_72450_a = d;
        point.field_72448_b = d1;
        point.field_72449_c = d2;
    }

    public static EntityPlayer getPlayerFromID(World world, int entityID) {
        for (Object o : world.field_73010_i) {
            if (!(o instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)o;
            if (player.field_70157_k != entityID) continue;
            return player;
        }
        return null;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(EntityPlayer player, boolean shouldCollide, float reach) {
        Vec3 position = player.field_70170_p.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() + (double)(player.field_70170_p.field_72995_K ? -player.getDefaultEyeHeight() : 0.0f), player.field_70161_v);
        float horizontalVectorFactor = -MathHelper.func_76134_b((float)(-player.field_70125_A * 0.01745f));
        float vectorAngleY = MathHelper.func_76126_a((float)(-player.field_70125_A * 0.01745f));
        float vectorAngleX = MathHelper.func_76126_a((float)(-player.field_70177_z * 0.01745f - (float)Math.PI)) * horizontalVectorFactor;
        float vectorAngleZ = MathHelper.func_76134_b((float)(-player.field_70177_z * 0.01745f - (float)Math.PI)) * horizontalVectorFactor;
        Vec3 lineOfSight = position.func_72441_c((double)vectorAngleX * (double)reach, (double)vectorAngleY * (double)reach, (double)vectorAngleZ * (double)reach);
        return player.field_70170_p.func_72831_a(position, lineOfSight, shouldCollide, !shouldCollide);
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(EntityPlayer player, boolean shouldCollide) {
        float reach = 5.0f;
        if (player instanceof EntityPlayerMP) {
            reach = (float)((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        return UtilMethods.getMovingObjectPositionFromPlayer(player, shouldCollide, reach);
    }
}

