/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.recipe;

import dnoved1.immersify.util.EnumMouseClick;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

@Deprecated
public class RecipeInput {
    private ItemStack[] ingredients;
    private boolean doIngredientsMatter;
    private ItemStack tool;
    private boolean doesToolMatter;
    private boolean isShiftHeld;
    private boolean doesShiftMatter;
    private EnumMouseClick mouseClick;
    private boolean doesMouseMatter;
    private EntityPlayer player = null;

    public RecipeInput(ItemStack[] ingredients) {
        this(ingredients, false, (EnumMouseClick)null);
        this.doesShiftMatter = false;
        this.doesMouseMatter = false;
    }

    public RecipeInput(ItemStack[] ingredients, boolean isShiftHeld) {
        this(ingredients, isShiftHeld, (EnumMouseClick)null);
        this.doesMouseMatter = false;
    }

    public RecipeInput(ItemStack[] ingredients, EnumMouseClick mouseClick) {
        this(ingredients, false, mouseClick);
        this.doesShiftMatter = false;
    }

    public RecipeInput(ItemStack[] ingredients, boolean isShiftHeld, EnumMouseClick mouseClick) {
        this(ingredients, null, isShiftHeld, mouseClick);
        this.doesToolMatter = false;
    }

    public RecipeInput(ItemStack[] ingredients, ItemStack tool) {
        this(ingredients, tool, false, null);
        this.doesShiftMatter = false;
        this.doesMouseMatter = false;
    }

    public RecipeInput(ItemStack[] ingredients, ItemStack tool, boolean isShiftHeld) {
        this(ingredients, tool, isShiftHeld, null);
        this.doesMouseMatter = false;
    }

    public RecipeInput(ItemStack[] ingredients, ItemStack tool, EnumMouseClick mouseClick) {
        this(ingredients, tool, false, mouseClick);
        this.doesShiftMatter = false;
    }

    public RecipeInput(ItemStack[] ingredients, ItemStack tool, boolean isShiftHeld, EnumMouseClick mouseClick) {
        this.ingredients = ingredients;
        this.doIngredientsMatter = true;
        this.tool = tool;
        this.doesToolMatter = true;
        this.isShiftHeld = isShiftHeld;
        this.doesShiftMatter = true;
        this.mouseClick = mouseClick;
        this.doesMouseMatter = true;
    }

    public void addPlayer(EntityPlayer player) {
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    public ItemStack getTool() {
        return this.tool;
    }

    public boolean isShiftHeld() {
        return this.isShiftHeld;
    }

    public EnumMouseClick getMouseClick() {
        return this.mouseClick;
    }

    public boolean doIngredientsMatch(RecipeInput otherRecipeInput) {
        int i;
        ItemStack[] otherIngredients = otherRecipeInput.getIngredients();
        if (this.ingredients.length != otherIngredients.length) {
            return false;
        }
        boolean[] matchFlags = new boolean[this.ingredients.length];
        block0: for (i = 0; i < this.ingredients.length; ++i) {
            for (int j = 0; j < otherIngredients.length; ++j) {
                if (matchFlags[i] || !ItemStack.func_77989_b((ItemStack)this.ingredients[i], (ItemStack)otherIngredients[j])) continue;
                matchFlags[i] = true;
                continue block0;
            }
        }
        for (i = 0; i < matchFlags.length; ++i) {
            if (matchFlags[i]) continue;
            return false;
        }
        return true;
    }

    public boolean doToolsMatch(RecipeInput otherRecipeInput) {
        ItemStack otherTool = otherRecipeInput.getTool();
        if (this.tool == null && otherTool == null) {
            return true;
        }
        if (this.tool == null || otherTool == null) {
            return false;
        }
        return !(this.tool.func_77973_b().func_77645_m() ? this.tool.field_77993_c != otherTool.field_77993_c || this.tool.field_77990_d != otherTool.field_77990_d : !ItemStack.func_77989_b((ItemStack)this.tool, (ItemStack)otherTool));
    }

    public boolean doShiftsMatch(RecipeInput otherRecipeInput) {
        return this.isShiftHeld == otherRecipeInput.isShiftHeld();
    }

    public boolean doMouseClicksMatch(RecipeInput otherRecipeInput) {
        return this.mouseClick == otherRecipeInput.getMouseClick();
    }

    public boolean matches(RecipeInput otherRecipeInput) {
        if (this.doesShiftMatter && !this.doShiftsMatch(otherRecipeInput)) {
            return false;
        }
        if (this.doesMouseMatter && !this.doMouseClicksMatch(otherRecipeInput)) {
            return false;
        }
        if (this.doesToolMatter && !this.doToolsMatch(otherRecipeInput)) {
            return false;
        }
        return !this.doIngredientsMatter || this.doIngredientsMatch(otherRecipeInput);
    }
}

