/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.graphics;

import dnoved1.immersify.util.UtilMethods;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ParticleCube
extends EntityFX {
    private static final double MINIMUM_DOUBLE_VALUE = 1.0E-4;
    protected Vec3[] cubePoints = new Vec3[8];
    protected float size;
    private boolean useCustomTextureBounds = false;
    private int textureStartX = 0;
    private int textureStartY = 0;
    private int textureLength = 16;
    protected double rotationSpeedX;
    protected double rotationSpeedY;
    protected double rotationSpeedZ;

    public ParticleCube(World world, float size, double x, double y, double z, double speedX, double speedY, double speedZ, double rotationSpeedX, double rotationSpeedY, double rotationSpeedZ) {
        super(world, x, y, z, speedX, speedY, speedZ);
        this.size = size;
        this.field_70159_w = speedX;
        this.field_70181_x = speedY;
        this.field_70179_y = speedZ;
        this.rotationSpeedX = rotationSpeedX;
        this.rotationSpeedY = rotationSpeedY;
        this.rotationSpeedZ = rotationSpeedZ;
        this.cubePoints[0] = Vec3.func_72443_a((double)1.0, (double)-1.0, (double)-1.0);
        this.cubePoints[1] = Vec3.func_72443_a((double)1.0, (double)-1.0, (double)1.0);
        this.cubePoints[2] = Vec3.func_72443_a((double)-1.0, (double)-1.0, (double)1.0);
        this.cubePoints[3] = Vec3.func_72443_a((double)-1.0, (double)-1.0, (double)-1.0);
        this.cubePoints[4] = Vec3.func_72443_a((double)1.0, (double)1.0, (double)-1.0);
        this.cubePoints[5] = Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0);
        this.cubePoints[6] = Vec3.func_72443_a((double)-1.0, (double)1.0, (double)1.0);
        this.cubePoints[7] = Vec3.func_72443_a((double)-1.0, (double)1.0, (double)-1.0);
    }

    public void setTexturePosistion(int startX, int startY) {
        this.textureStartX = startX;
        this.textureStartY = startY;
        this.useCustomTextureBounds = true;
    }

    public int getTextureStartX() {
        return this.useCustomTextureBounds ? this.textureStartX : this.field_94054_b * this.textureLength;
    }

    public int getTextureStartY() {
        return this.useCustomTextureBounds ? this.textureStartY : this.field_94055_c * this.textureLength;
    }

    public void setTextureLength(int length) {
        this.textureLength = length;
    }

    public int getTextureLength() {
        return this.textureLength;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.rotationSpeedX *= 0.98;
        this.rotationSpeedY *= 0.98;
        this.rotationSpeedZ *= 0.98;
        if (this.field_70122_E) {
            this.rotationSpeedX *= 0.7;
            this.rotationSpeedY *= 0.7;
            this.rotationSpeedZ *= 0.7;
        }
        if (Math.abs(this.field_70159_w) < 1.0E-4) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 1.0E-4) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 1.0E-4) {
            this.field_70179_y = 0.0;
        }
        if (Math.abs(this.rotationSpeedX) < 1.0E-4) {
            this.rotationSpeedX = 0.0;
        }
        if (Math.abs(this.rotationSpeedY) < 1.0E-4) {
            this.rotationSpeedY = 0.0;
        }
        if (Math.abs(this.rotationSpeedY) < 1.0E-4) {
            this.rotationSpeedY = 0.0;
        }
        for (Vec3 cubePoint : this.cubePoints) {
            if (this.rotationSpeedX != 0.0) {
                cubePoint.func_72440_a((float)(Math.PI * this.rotationSpeedX));
            }
            if (this.rotationSpeedY != 0.0) {
                cubePoint.func_72442_b((float)(Math.PI * this.rotationSpeedY));
            }
            if (this.rotationSpeedZ == 0.0) continue;
            UtilMethods.rotateAroundZ(cubePoint, (float)(Math.PI * this.rotationSpeedZ));
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        int textureSheetLength = this.func_70537_b() == 0 ? 128 : 256;
        float pixelLength = 1.0f / (float)textureSheetLength;
        float xLeft = (float)this.getTextureStartX() * pixelLength;
        float xRight = xLeft + (float)this.textureLength * pixelLength;
        float yTop = (float)this.getTextureStartY() * pixelLength;
        float yBottom = yTop + (float)this.textureLength * pixelLength;
        float xRenderPos = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTick - field_70556_an);
        float yRenderPos = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTick - field_70554_ao);
        float zRenderPos = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTick - field_70555_ap);
        tessellator.func_78386_a(this.field_70552_h, this.field_70553_i, this.field_70551_j);
        tessellator.func_78374_a(this.cubePoints[0].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[0].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[0].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[1].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[1].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[1].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[2].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[2].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[2].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[3].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[3].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[3].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[5].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[5].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[5].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[4].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[4].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[4].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[7].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[7].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[7].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[6].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[6].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[6].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[4].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[4].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[4].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[5].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[5].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[5].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[1].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[1].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[1].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[0].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[0].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[0].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[6].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[6].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[6].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[7].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[7].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[7].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[3].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[3].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[3].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[2].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[2].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[2].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[1].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[1].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[1].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[5].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[5].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[5].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[6].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[6].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[6].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[2].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[2].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[2].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[4].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[4].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[4].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yBottom);
        tessellator.func_78374_a(this.cubePoints[0].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[0].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[0].field_72449_c * (double)this.size + (double)zRenderPos, (double)xRight, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[3].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[3].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[3].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yTop);
        tessellator.func_78374_a(this.cubePoints[7].field_72450_a * (double)this.size + (double)xRenderPos, this.cubePoints[7].field_72448_b * (double)this.size + (double)yRenderPos, this.cubePoints[7].field_72449_c * (double)this.size + (double)zRenderPos, (double)xLeft, (double)yBottom);
    }
}

