/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.dimension;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import mods.natura.dimension.FireGen;
import mods.natura.dimension.NetheriteChunk;
import mods.natura.worldgen.FlowerGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import net.minecraft.world.gen.feature.WorldGenGlowStone2;
import net.minecraft.world.gen.feature.WorldGenHellLava;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class NetheriteChunkProvider
implements IChunkProvider {
    private Random hellRNG;
    private NoiseGeneratorOctaves netherNoiseGen1;
    private NoiseGeneratorOctaves netherNoiseGen2;
    private NoiseGeneratorOctaves netherNoiseGen3;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves netherNoiseGen4;
    public NoiseGeneratorOctaves netherNoiseGen5;
    private World worldObj;
    private double[] noiseField;
    private double[] secondNoiseField;
    public MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] netherrackExclusivityNoise = new double[256];
    private MapGenBase netherCaveGenerator = new MapGenCavesHell();
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    double[] secondNoiseData1;
    double[] secondNoiseData2;
    double[] secondNoiseData3;
    double[] secondNoiseData4;
    double[] secondNoiseData5;

    public NetheriteChunkProvider(World par1World, long par2) {
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.netherCaveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.netherCaveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.worldObj = par1World;
        this.hellRNG = new Random(par2);
        this.netherNoiseGen1 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen2 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen3 = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherNoiseGen4 = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.netherNoiseGen5 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.netherNoiseGen1, this.netherNoiseGen2, this.netherNoiseGen3, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.netherNoiseGen4, this.netherNoiseGen5};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)par1World, (Random)this.hellRNG, (NoiseGenerator[])noiseGens);
        this.netherNoiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.netherNoiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.netherNoiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.slowsandGravelNoiseGen = (NoiseGeneratorOctaves)noiseGens[3];
        this.netherrackExculsivityNoiseGen = (NoiseGeneratorOctaves)noiseGens[4];
        this.netherNoiseGen4 = (NoiseGeneratorOctaves)noiseGens[5];
        this.netherNoiseGen5 = (NoiseGeneratorOctaves)noiseGens[6];
    }

    public void generateNetherTerrain(int chunkX, int chunkZ, Block[] lowerIDs) {
        int noiseInit = 4;
        int b1 = 32;
        int k = noiseInit + 1;
        int b2 = 17;
        int l = noiseInit + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, chunkX * noiseInit, 0, chunkZ * noiseInit, k, b2, l);
        for (int iterX = 0; iterX < noiseInit; ++iterX) {
            for (int iterZ = 0; iterZ < noiseInit; ++iterZ) {
                for (int iterY = 0; iterY < 16; ++iterY) {
                    double noiseOffset = 0.125;
                    double n1 = this.noiseField[((iterX + 0) * l + iterZ + 0) * b2 + iterY + 0];
                    double n2 = this.noiseField[((iterX + 0) * l + iterZ + 1) * b2 + iterY + 0];
                    double n3 = this.noiseField[((iterX + 1) * l + iterZ + 0) * b2 + iterY + 0];
                    double n4 = this.noiseField[((iterX + 1) * l + iterZ + 1) * b2 + iterY + 0];
                    double n5 = (this.noiseField[((iterX + 0) * l + iterZ + 0) * b2 + iterY + 1] - n1) * noiseOffset;
                    double n6 = (this.noiseField[((iterX + 0) * l + iterZ + 1) * b2 + iterY + 1] - n2) * noiseOffset;
                    double n7 = (this.noiseField[((iterX + 1) * l + iterZ + 0) * b2 + iterY + 1] - n3) * noiseOffset;
                    double n8 = (this.noiseField[((iterX + 1) * l + iterZ + 1) * b2 + iterY + 1] - n4) * noiseOffset;
                    for (int offsetY = 0; offsetY < 8; ++offsetY) {
                        double d9 = 0.25;
                        double d10 = n1;
                        double d11 = n2;
                        double d12 = (n3 - n1) * d9;
                        double d13 = (n4 - n2) * d9;
                        for (int offsetX = 0; offsetX < 4; ++offsetX) {
                            int layerPos = offsetX + iterX * 4 << 11 | 0 + iterZ * 4 << 7 | iterY * 8 + offsetY;
                            int amountPerLayer = 128;
                            double d14 = 0.25;
                            double lValue = d10;
                            double lOffset = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                Block blockID = Blocks.field_150350_a;
                                if (iterY * 8 + offsetY < b1) {
                                    blockID = Blocks.field_150353_l;
                                }
                                if (lValue > 0.0) {
                                    blockID = Blocks.field_150424_aL;
                                }
                                if (lValue > 56.0) {
                                    blockID = NContent.taintedSoil;
                                }
                                lowerIDs[layerPos] = blockID;
                                layerPos += amountPerLayer;
                                lValue += lOffset;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        n1 += n5;
                        n2 += n6;
                        n3 += n7;
                        n4 += n8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, Block[] blocks, Block[] lowerIDs) {
        int seaLevel = 64;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, par1 * 16, 109, par2 * 16, 16, 1, 16, d0, 1.0, d0);
        this.netherrackExclusivityNoise = this.netherrackExculsivityNoiseGen.func_76304_a(this.netherrackExclusivityNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int iterX = 0; iterX < 16; ++iterX) {
            for (int iterZ = 0; iterZ < 16; ++iterZ) {
                boolean flag = this.slowsandNoise[iterX + iterZ * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[iterX + iterZ * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                int i1 = (int)(this.netherrackExclusivityNoise[iterX + iterZ * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int j1 = -1;
                Block b1 = Blocks.field_150424_aL;
                Block b2 = NContent.taintedSoil;
                for (int k1 = 127; k1 >= 0; --k1) {
                    int l1 = (iterZ * 16 + iterX) * 128 + k1;
                    if (k1 < 127 - this.hellRNG.nextInt(5) && k1 > 0 + this.hellRNG.nextInt(5)) {
                        Block b3 = lowerIDs[l1];
                        if (b3 == null || b3 == Blocks.field_150350_a) {
                            j1 = -1;
                            continue;
                        }
                        if (b3 != Blocks.field_150424_aL) continue;
                        if (j1 == -1) {
                            if (i1 <= 0) {
                                b1 = null;
                                b2 = Blocks.field_150424_aL;
                            } else if (k1 >= seaLevel - 4 && k1 <= seaLevel + 1) {
                                b1 = Blocks.field_150424_aL;
                                b2 = NContent.taintedSoil;
                                if (flag1) {
                                    b1 = Blocks.field_150351_n;
                                }
                                if (flag1) {
                                    b2 = Blocks.field_150424_aL;
                                }
                                if (flag) {
                                    b1 = Blocks.field_150425_aM;
                                }
                                if (flag) {
                                    b2 = NContent.heatSand;
                                }
                            }
                            if (k1 < seaLevel && b1 == null || b1 == Blocks.field_150350_a) {
                                b1 = Blocks.field_150353_l;
                            }
                            j1 = i1;
                            if (k1 >= seaLevel - 1) {
                                lowerIDs[l1] = b1;
                                continue;
                            }
                            lowerIDs[l1] = b2;
                            continue;
                        }
                        if (j1 <= 0) continue;
                        --j1;
                        lowerIDs[l1] = b2;
                        continue;
                    }
                    lowerIDs[l1] = Blocks.field_150357_h;
                }
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.hellRNG.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        Block[] lowerArray = new Block[32768];
        Block[] aBlock = new Block[32768];
        this.generateNetherTerrain(chunkX, chunkZ, lowerArray);
        this.replaceBlocksForBiome(chunkX, chunkZ, aBlock, lowerArray);
        this.netherCaveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, aBlock);
        this.genNetherBridge.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, aBlock);
        NetheriteChunk chunk = new NetheriteChunk(this.worldObj, lowerArray, chunkX, chunkZ);
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, chunkX * 16, chunkZ * 16, 16, 16);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)abiomegenbase[k].field_76756_M;
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        int i2;
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, par1ArrayOfDouble, par2, par3, par4, par5, par6, par7);
        MinecraftForge.EVENT_BUS.post((Event)event);
        event.getResult();
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.netherNoiseGen4.func_76304_a(this.noiseData4, par2, par3, par4, par5, 1, par7, 1.0, 0.0, 1.0);
        this.noiseData5 = this.netherNoiseGen5.func_76304_a(this.noiseData5, par2, par3, par4, par5, 1, par7, 100.0, 0.0, 100.0);
        this.noiseData1 = this.netherNoiseGen3.func_76304_a(this.noiseData1, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.netherNoiseGen1.func_76304_a(this.noiseData2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        this.noiseData3 = this.netherNoiseGen2.func_76304_a(this.noiseData3, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[par6];
        for (i2 = 0; i2 < par6; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)par6) * 2.0;
            double d2 = i2;
            if (i2 > par6 / 2) {
                d2 = par6 - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < par5; ++i2) {
            for (int j2 = 0; j2 < par7; ++j2) {
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)par6 / 16.0;
                ++l1;
                for (int k2 = 0; k2 < par6; ++k2) {
                    double d11;
                    double d6 = 0.0;
                    double d7 = adouble1[k2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k2 > par6 - 4) {
                        d11 = (float)(k2 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)k2 < d4) {
                        d11 = (d4 - (double)k2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1ArrayOfDouble[k1] = d6;
                    ++k1;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int k6;
        int l4;
        int i3;
        int j2;
        int i2;
        int zPos;
        int yPos;
        int xPos;
        int i1;
        BlockFalling.field_149832_M = true;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.hellRNG, par2, par3, false));
        int blockX = par2 * 16;
        int blockZ = par3 * 16;
        this.genNetherBridge.func_75051_a(this.worldObj, this.hellRNG, par2, par3);
        boolean doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.hellRNG, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 8; ++i1) {
            xPos = blockX + this.hellRNG.nextInt(16) + 8;
            yPos = this.hellRNG.nextInt(120) + 4;
            zPos = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenHellLava(Blocks.field_150353_l, false).func_76484_a(this.worldObj, this.hellRNG, xPos, yPos, zPos);
        }
        i1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1) + 1;
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.hellRNG, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE);
        for (xPos = 0; doGen && xPos < i1; ++xPos) {
            yPos = blockX + this.hellRNG.nextInt(16) + 8;
            zPos = this.hellRNG.nextInt(120) + 4;
            i2 = blockZ + this.hellRNG.nextInt(16) + 8;
            new FireGen().func_76484_a(this.worldObj, this.hellRNG, yPos, zPos, i2);
        }
        i1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.hellRNG, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE);
        for (xPos = 0; doGen && xPos < i1; ++xPos) {
            yPos = blockX + this.hellRNG.nextInt(16) + 8;
            zPos = this.hellRNG.nextInt(120) + 4;
            i2 = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone1().func_76484_a(this.worldObj, this.hellRNG, yPos, zPos, i2);
        }
        for (xPos = 0; doGen && xPos < 10; ++xPos) {
            yPos = blockX + this.hellRNG.nextInt(16) + 8;
            zPos = this.hellRNG.nextInt(128);
            i2 = blockZ + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone2().func_76484_a(this.worldObj, this.hellRNG, yPos, zPos, i2);
        }
        WorldGenMinable worldgenminable = new WorldGenMinable(Blocks.field_150449_bY, 13, Blocks.field_150424_aL);
        for (yPos = 0; yPos < 16; ++yPos) {
            zPos = blockX + this.hellRNG.nextInt(16);
            i2 = this.hellRNG.nextInt(108) + 10;
            j2 = blockZ + this.hellRNG.nextInt(16);
            worldgenminable.func_76484_a(this.worldObj, this.hellRNG, zPos, i2, j2);
        }
        for (yPos = 0; yPos < 16; ++yPos) {
            zPos = blockX + this.hellRNG.nextInt(16);
            i2 = this.hellRNG.nextInt(108) + 10;
            j2 = blockZ + this.hellRNG.nextInt(16);
            new WorldGenHellLava(Blocks.field_150353_l, true).func_76484_a(this.worldObj, this.hellRNG, zPos, i2, j2);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.hellRNG, blockX, blockZ));
        doGen = TerrainGen.decorate((World)this.worldObj, (Random)this.hellRNG, (int)blockX, (int)blockZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM);
        if (PHNatura.generateGreenglowshroom && doGen && this.hellRNG.nextInt(7) == 0) {
            int l2 = blockX + this.hellRNG.nextInt(16) + 8;
            int k4 = this.hellRNG.nextInt(128);
            int j6 = blockZ + this.hellRNG.nextInt(16) + 8;
            new FlowerGen((Block)NContent.glowshroom, 0).func_76484_a(this.worldObj, this.hellRNG, l2, k4, j6);
        }
        if (PHNatura.generatePurpleglowshroom && doGen && this.hellRNG.nextInt(8) == 0) {
            i3 = blockX + this.hellRNG.nextInt(16) + 8;
            l4 = this.hellRNG.nextInt(128);
            k6 = blockZ + this.hellRNG.nextInt(16) + 8;
            new FlowerGen((Block)NContent.glowshroom, 1).func_76484_a(this.worldObj, this.hellRNG, i3, l4, k6);
        }
        if (PHNatura.generateBlueglowshroom && doGen && this.hellRNG.nextInt(9) == 0) {
            i3 = blockX + this.hellRNG.nextInt(16) + 8;
            l4 = this.hellRNG.nextInt(128);
            k6 = blockZ + this.hellRNG.nextInt(16) + 8;
            new FlowerGen((Block)NContent.glowshroom, 2).func_76484_a(this.worldObj, this.hellRNG, i3, l4, k6);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.hellRNG, blockX, blockZ));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.hellRNG, par2, par3, false));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "HellRandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        if (par1EnumCreatureType == EnumCreatureType.monster && this.genNetherBridge.func_75048_a(par2, par3, par4)) {
            return this.genNetherBridge.func_75059_a();
        }
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase == null ? null : biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        this.genNetherBridge.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, null);
    }

    public void func_104112_b() {
    }
}

