/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.blocks.NSlabBase;
import mods.natura.client.GrassColorizerAlternate;
import mods.natura.common.NaturaTab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;

public class GrassSlab
extends NSlabBase {
    public GrassSlab() {
        super(Material.ground);
        this.setHardness(0.6f);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("natura:grass_top");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.blockIcon;
    }

    @Override
    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerGrass.getGrassColor((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int meta) {
        double d0 = 0.5;
        double d1 = 1.0;
        if (meta == 1) {
            return GrassColorizerAlternate.getBlueGrassColor(d0, 0.5);
        }
        if (meta == 2) {
            return GrassColorizerAlternate.getOrangeGrassColor(1.0, 1.0);
        }
        return ColorizerGrass.getGrassColor((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        int l = 0;
        int i1 = 0;
        int j1 = 0;
        int meta = world.getBlockMetadata(x, y, z);
        for (int k1 = -1; k1 <= 1; ++k1) {
            for (int l1 = -1; l1 <= 1; ++l1) {
                double rainfall;
                double temp;
                BiomeGenBase biome = world.getBiomeGenForCoords(x + l1, z + k1);
                int grassColor = 0;
                if (meta == 1) {
                    temp = MathHelper.clamp_float((float)biome.getFloatTemperature(x, y, z), (float)0.0f, (float)1.0f);
                    rainfall = MathHelper.clamp_float((float)biome.getFloatRainfall(), (float)0.0f, (float)1.0f);
                    grassColor = GrassColorizerAlternate.getBlueGrassColor(temp, rainfall);
                } else if (meta == 2) {
                    temp = MathHelper.clamp_float((float)biome.getFloatTemperature(x, y, z), (float)0.0f, (float)1.0f);
                    rainfall = MathHelper.clamp_float((float)biome.getFloatRainfall(), (float)0.0f, (float)1.0f);
                    grassColor = GrassColorizerAlternate.getOrangeGrassColor(temp, rainfall);
                } else {
                    grassColor = biome.getBiomeGrassColor(x, y, z);
                }
                l += (grassColor & 0xFF0000) >> 16;
                i1 += (grassColor & 0xFF00) >> 8;
                j1 += grassColor & 0xFF;
            }
        }
        return (l / 9 & 0xFF) << 16 | (i1 / 9 & 0xFF) << 8 | j1 / 9 & 0xFF;
    }
}

