/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class SeedFood
extends ItemSeedFood {
    public Block crop;

    public SeedFood(int hunger, float saturation, Block cropID) {
        super(hunger, saturation, cropID, Blocks.farmland);
        this.crop = cropID;
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        if (side != 1) {
            return false;
        }
        if (player.canPlayerEdit(x, y, z, side, stack) && player.canPlayerEdit(x, y + 1, z, side, stack)) {
            Block soil = world.getBlock(x, y, z);
            if (soil != null && soil.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)NContent.saguaro) && world.isAirBlock(x, y + 1, z)) {
                world.setBlock(x, y + 1, z, this.crop, 1, 3);
                --stack.stackSize;
                if (!world.isRemote) {
                    world.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)this.crop));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("natura:saguaro_fruit_item");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.translateToLocal((String)"tooltip.sagurofruit"));
    }
}

