/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.plugins.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mods.natura.blocks.crops.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class NaturaCropDataProvider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (accessor.getBlock() instanceof CropBlock) {
            int meta = accessor.getMetadata();
            CropBlock cropBlock = (CropBlock)block;
            return new ItemStack(cropBlock.getCropItem(meta), 1, cropBlock.damageDropped(meta));
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block;
        if (config.getConfig("general.showcrop") && (block = accessor.getBlock()) instanceof CropBlock) {
            float maxGrowth;
            float startGrowth;
            int meta = accessor.getMetadata();
            float growthValue = ((float)meta - (startGrowth = (float)((CropBlock)block).getStartGrowth(meta))) / (maxGrowth = (float)((CropBlock)block).getMaxGrowth(meta) - startGrowth) * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(StatCollector.translateToLocalFormatted((String)"tooltip.waila.growth.percentage", (Object[])new Object[]{Float.valueOf(growthValue)}));
            } else {
                currenttip.add(StatCollector.translateToLocal((String)"tooltip.waila.growth.mature"));
            }
            return currenttip;
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

