/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.MultiItemBlock;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class NetherBerryBushItem
extends MultiItemBlock {
    public static final String[] blockType = new String[]{"blight", "dusk", "sky", "sting", "blight", "dusk", "sky", "sting", "blight", "dusk", "sky", "sting", "blight", "dusk", "sky", "sting"};

    public NetherBerryBushItem(Block block) {
        super(block, "block.bush.berry", blockType);
        this.setHasSubtypes(true);
    }

    public int getMetadata(int meta) {
        return meta % 4;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (side != 1) {
            return false;
        }
        if (player.canPlayerEdit(x, y, z, side, stack) && player.canPlayerEdit(x, y + 1, z, side, stack)) {
            Block block = world.getBlock(x, y, z);
            if (block != null && (block.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)NContent.netherBerryBush) || block == Blocks.netherrack) && world.isAirBlock(x, y + 1, z)) {
                world.setBlock(x, y + 1, z, (Block)NContent.netherBerryBush, stack.getItemDamage() % 4, 3);
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                }
                if (!world.isRemote) {
                    world.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)NContent.netherBerryBush));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush1"));
        switch (stack.getItemDamage() % 4) {
            case 0: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush2"));
                break;
            }
            case 1: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush3"));
                break;
            }
            case 2: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush4"));
                break;
            }
            case 3: {
                list.add(StatCollector.translateToLocal((String)"tooltip.netherberrybush5"));
            }
        }
    }
}

