/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.tech;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NetherPistonBase
extends BlockPistonBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon iIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon tIcon;
    private boolean sticky;

    public NetherPistonBase(boolean sticky) {
        super(sticky);
        this.sticky = sticky;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPistonExtensionTexture() {
        return this.tIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getBaseIcon(String par0Str) {
        return par0Str == "piston_side" ? NContent.piston.blockIcon : (par0Str == "piston_top_normal" ? NContent.piston.tIcon : (par0Str == "piston_top_sticky" ? NContent.piston.tIcon : (par0Str == "piston_inner" ? NContent.piston.iIcon : null)));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon("natura:piston_side");
        this.tIcon = par1IconRegister.registerIcon(this.sticky ? "natura:piston_top_sticky" : "natura:piston_top_normal");
        this.iIcon = par1IconRegister.registerIcon("natura:piston_inner");
        this.bIcon = par1IconRegister.registerIcon("natura:piston_bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        int k = NetherPistonBase.getOrientation(meta);
        return k > 5 ? this.tIcon : (side == k ? (!NetherPistonBase.isExtended(meta) && this.minX <= 0.0 && this.minY <= 0.0 && this.minZ <= 0.0 && this.maxX >= 1.0 && this.maxY >= 1.0 && this.maxZ >= 1.0 ? this.tIcon : this.iIcon) : (side == Facing.oppositeSide[k] ? this.bIcon : this.blockIcon));
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        return false;
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = NetherPistonBase.determineOrientation(par1World, par2, par3, par4, par5EntityLivingBase);
        par1World.setBlockMetadataWithNotify(par2, par3, par4, l, 2);
        if (!par1World.isRemote) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (!par1World.isRemote) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        if (!par1World.isRemote && par1World.getTileEntity(par2, par3, par4) == null) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    private void updatePistonState(World par1World, int par2, int par3, int par4) {
        int l = par1World.getBlockMetadata(par2, par3, par4);
        int i1 = NetherPistonBase.getOrientation(l);
        if (i1 != 7) {
            boolean flag = this.isIndirectlyPowered(par1World, par2, par3, par4, i1);
            if (flag && !NetherPistonBase.isExtended(l)) {
                if (NetherPistonBase.canExtend(par1World, par2, par3, par4, i1)) {
                    par1World.addBlockEvent(par2, par3, par4, (Block)this, 0, i1);
                }
            } else if (!flag && NetherPistonBase.isExtended(l)) {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, i1, 2);
                par1World.addBlockEvent(par2, par3, par4, (Block)this, 1, i1);
            }
        }
    }

    private boolean isIndirectlyPowered(World par1World, int par2, int par3, int par4, int par5) {
        return par5 != 0 && par1World.getIndirectPowerOutput(par2, par3 - 1, par4, 0) ? true : (par5 != 1 && par1World.getIndirectPowerOutput(par2, par3 + 1, par4, 1) ? true : (par5 != 2 && par1World.getIndirectPowerOutput(par2, par3, par4 - 1, 2) ? true : (par5 != 3 && par1World.getIndirectPowerOutput(par2, par3, par4 + 1, 3) ? true : (par5 != 5 && par1World.getIndirectPowerOutput(par2 + 1, par3, par4, 5) ? true : (par5 != 4 && par1World.getIndirectPowerOutput(par2 - 1, par3, par4, 4) ? true : (par1World.getIndirectPowerOutput(par2, par3, par4, 0) ? true : (par1World.getIndirectPowerOutput(par2, par3 + 2, par4, 1) ? true : (par1World.getIndirectPowerOutput(par2, par3 + 1, par4 - 1, 2) ? true : (par1World.getIndirectPowerOutput(par2, par3 + 1, par4 + 1, 3) ? true : (par1World.getIndirectPowerOutput(par2 - 1, par3 + 1, par4, 4) ? true : par1World.getIndirectPowerOutput(par2 + 1, par3 + 1, par4, 5)))))))))));
    }

    public boolean onBlockEventReceived(World par1World, int par2, int par3, int par4, int par5, int par6) {
        if (!par1World.isRemote) {
            boolean flag = this.isIndirectlyPowered(par1World, par2, par3, par4, par6);
            if (flag && par5 == 1) {
                par1World.setBlockMetadataWithNotify(par2, par3, par4, par6 | 8, 2);
                return false;
            }
            if (!flag && par5 == 0) {
                return false;
            }
        }
        if (par5 == 0) {
            if (!this.tryExtend(par1World, par2, par3, par4, par6)) {
                return false;
            }
            par1World.setBlockMetadataWithNotify(par2, par3, par4, par6 | 8, 2);
            par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "tile.piston.out", 0.5f, par1World.rand.nextFloat() * 0.25f + 0.6f);
        } else if (par5 == 1) {
            TileEntity tileentity = par1World.getTileEntity(par2 + Facing.offsetsXForSide[par6], par3 + Facing.offsetsYForSide[par6], par4 + Facing.offsetsZForSide[par6]);
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).clearPistonTileEntity();
            }
            par1World.setBlock(par2, par3, par4, (Block)Blocks.piston, par6, 3);
            par1World.setTileEntity(par2, par3, par4, BlockPistonMoving.getTileEntity((Block)this, (int)par6, (int)par6, (boolean)false, (boolean)true));
            if (this.sticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                int j1 = par2 + Facing.offsetsXForSide[par6] * 2;
                int k1 = par3 + Facing.offsetsYForSide[par6] * 2;
                int l1 = par4 + Facing.offsetsZForSide[par6] * 2;
                Block i2 = par1World.getBlock(j1, k1, l1);
                int j2 = par1World.getBlockMetadata(j1, k1, l1);
                boolean flag1 = false;
                if (i2 == Blocks.piston && (tileentity1 = par1World.getTileEntity(j1, k1, l1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).getPistonOrientation() == par6 && tileentitypiston.isExtending()) {
                    tileentitypiston.clearPistonTileEntity();
                    i2 = tileentitypiston.getStoredBlockID();
                    j2 = tileentitypiston.getBlockMetadata();
                    flag1 = true;
                }
                if (!flag1 && i2 != null && NetherPistonBase.canPushBlock(i2, par1World, j1, k1, l1, false) && (i2.getMobilityFlag() == 0 || i2 == NContent.piston || i2 == NContent.pistonSticky)) {
                    par1World.setBlock(par2 += Facing.offsetsXForSide[par6], par3 += Facing.offsetsYForSide[par6], par4 += Facing.offsetsZForSide[par6], (Block)Blocks.piston, j2, 3);
                    par1World.setTileEntity(par2, par3, par4, BlockPistonMoving.getTileEntity((Block)i2, (int)j2, (int)par6, (boolean)false, (boolean)false));
                    par1World.setBlockToAir(j1, k1, l1);
                } else if (!flag1) {
                    par1World.setBlockToAir(par2 + Facing.offsetsXForSide[par6], par3 + Facing.offsetsYForSide[par6], par4 + Facing.offsetsZForSide[par6]);
                }
            } else {
                par1World.setBlockToAir(par2 + Facing.offsetsXForSide[par6], par3 + Facing.offsetsYForSide[par6], par4 + Facing.offsetsZForSide[par6]);
            }
            par1World.playSoundEffect((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "tile.piston.in", 0.5f, par1World.rand.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int l = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if (NetherPistonBase.isExtended(l)) {
            float f = 0.25f;
            switch (NetherPistonBase.getOrientation(l)) {
                case 0: {
                    this.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void addCollisionBoxesToList(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.addCollisionBoxesToList(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, par2, par3, par4);
        return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public static int getOrientation(int par0) {
        return par0 & 7;
    }

    public static boolean isExtended(int par0) {
        return (par0 & 8) != 0;
    }

    public static int determineOrientation(World par0World, int par1, int par2, int par3, EntityLivingBase par4EntityLivingBase) {
        int l;
        if (MathHelper.abs((float)((float)par4EntityLivingBase.posX - (float)par1)) < 2.0f && MathHelper.abs((float)((float)par4EntityLivingBase.posZ - (float)par3)) < 2.0f) {
            double d0 = par4EntityLivingBase.posY + 1.82 - (double)par4EntityLivingBase.yOffset;
            if (d0 - (double)par2 > 2.0) {
                return 1;
            }
            if ((double)par2 - d0 > 0.0) {
                return 0;
            }
        }
        return (l = MathHelper.floor_double((double)((double)(par4EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : (l == 3 ? 4 : 0)));
    }

    private static boolean canPushBlock(Block par0, World par1World, int par2, int par3, int par4, boolean par5) {
        if (par0 == Blocks.obsidian) {
            return false;
        }
        if (par0 != NContent.piston && par0 != NContent.pistonSticky) {
            if (par0.getBlockHardness(par1World, par2, par3, par4) == -1.0f) {
                return false;
            }
            if (par0.getMobilityFlag() == 2) {
                return false;
            }
            if (par0.getMobilityFlag() == 1) {
                return par5;
            }
        } else if (NetherPistonBase.isExtended(par1World.getBlockMetadata(par2, par3, par4))) {
            return false;
        }
        return !par1World.getBlock(par2, par3, par4).hasTileEntity(0);
    }

    private static boolean canExtend(World par0World, int par1, int par2, int par3, int par4) {
        int i1 = par1 + Facing.offsetsXForSide[par4];
        int j1 = par2 + Facing.offsetsYForSide[par4];
        int k1 = par3 + Facing.offsetsZForSide[par4];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (j1 <= 0 || j1 >= par0World.getHeight() - 1) {
                return false;
            }
            Block i2 = par0World.getBlock(i1, j1, k1);
            if (par0World.isAirBlock(i1, j1, k1)) break;
            if (!NetherPistonBase.canPushBlock(i2, par0World, i1, j1, k1, true)) {
                return false;
            }
            if (i2.getMobilityFlag() == 1) break;
            if (l1 == 12) {
                return false;
            }
            i1 += Facing.offsetsXForSide[par4];
            j1 += Facing.offsetsYForSide[par4];
            k1 += Facing.offsetsZForSide[par4];
        }
        return true;
    }

    private boolean tryExtend(World par1World, int par2, int par3, int par4, int par5) {
        int j3;
        int i3;
        int l2;
        Block i2;
        int l1;
        int newX = par2 + Facing.offsetsXForSide[par5];
        int newY = par3 + Facing.offsetsYForSide[par5];
        int newZ = par4 + Facing.offsetsZForSide[par5];
        for (l1 = 0; l1 < 13; ++l1) {
            if (newY <= 0 || newY >= par1World.getHeight() - 1) {
                return false;
            }
            i2 = par1World.getBlock(newX, newY, newZ);
            if (par1World.isAirBlock(newX, newY, newZ)) break;
            if (!NetherPistonBase.canPushBlock(i2, par1World, newX, newY, newZ, true)) {
                return false;
            }
            if (i2.getMobilityFlag() != 1) {
                if (l1 == 12) {
                    return false;
                }
                newX += Facing.offsetsXForSide[par5];
                newY += Facing.offsetsYForSide[par5];
                newZ += Facing.offsetsZForSide[par5];
                continue;
            }
            float chance = i2 instanceof BlockSnow ? -1.0f : 1.0f;
            i2.dropBlockAsItemWithChance(par1World, newX, newY, newZ, par1World.getBlockMetadata(newX, newY, newZ), chance, 0);
            par1World.setBlockToAir(newX, newY, newZ);
            break;
        }
        l1 = newX;
        i2 = par1World.getBlock(newX, newY, newZ);
        int j2 = newZ;
        int k2 = 0;
        Block[] aint = new Block[13];
        while (newX != par2 || newY != par3 || newZ != par4) {
            l2 = newX - Facing.offsetsXForSide[par5];
            i3 = newY - Facing.offsetsYForSide[par5];
            j3 = newZ - Facing.offsetsZForSide[par5];
            Block k3 = par1World.getBlock(l2, i3, j3);
            int l3 = par1World.getBlockMetadata(l2, i3, j3);
            if (k3 == this && l2 == par2 && i3 == par3 && j3 == par4) {
                par1World.setBlock(newX, newY, newZ, (Block)Blocks.piston, par5 | (this.sticky ? 8 : 0), 4);
                par1World.setTileEntity(newX, newY, newZ, BlockPistonMoving.getTileEntity((Block)NContent.pistonExtension, (int)(par5 | (this.sticky ? 8 : 0)), (int)par5, (boolean)true, (boolean)false));
            } else {
                par1World.setBlock(newX, newY, newZ, (Block)Blocks.piston, l3, 4);
                par1World.setTileEntity(newX, newY, newZ, BlockPistonMoving.getTileEntity((Block)k3, (int)l3, (int)par5, (boolean)true, (boolean)false));
            }
            aint[k2++] = k3;
            newX = l2;
            newY = i3;
            newZ = j3;
        }
        newX = l1;
        i2 = par1World.getBlock(newX, newY, newZ);
        newZ = j2;
        k2 = 0;
        while (newX != par2 || newY != par3 || newZ != par4) {
            l2 = newX - Facing.offsetsXForSide[par5];
            i3 = newY - Facing.offsetsYForSide[par5];
            j3 = newZ - Facing.offsetsZForSide[par5];
            par1World.notifyBlocksOfNeighborChange(l2, i3, j3, aint[k2++]);
            newX = l2;
            newY = i3;
            newZ = j3;
        }
        return true;
    }
}

