/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class DarkwoodGen
extends WorldGenerator {
    private final int minTreeHeight;
    private final int metaWood;
    private final boolean seekGround;

    public DarkwoodGen(boolean par1) {
        this(par1, 4, 0);
    }

    public DarkwoodGen(boolean par1, int par2, int par3) {
        super(par1);
        this.minTreeHeight = par2;
        this.metaWood = par3;
        this.seekGround = !par1;
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = y;
        do {
            Block underID;
            if ((underID = world.getBlock(x, --height, z)) != Blocks.netherrack && underID != Blocks.soul_sand && underID != NContent.taintedSoil && height >= 0) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }

    public boolean generate(World world, Random random, int xPos, int yPos, int zPos) {
        int treeHeight = random.nextInt(3) + this.minTreeHeight;
        if (treeHeight < 4) {
            treeHeight = 4;
        }
        boolean flag = true;
        if (this.seekGround) {
            yPos = this.findGround(world, xPos, yPos, zPos);
        }
        if (yPos >= 1 && yPos + treeHeight + 1 <= 256) {
            boolean isSoil;
            int j1;
            int b0;
            for (int i1 = yPos; i1 <= yPos + 1 + treeHeight; ++i1) {
                b0 = 1;
                if (i1 == yPos) {
                    b0 = 0;
                }
                if (i1 >= yPos + 1 + treeHeight - 2) {
                    b0 = 2;
                }
                for (int l1 = xPos - b0; l1 <= xPos + b0 && flag; ++l1) {
                    for (j1 = zPos - b0; j1 <= zPos + b0 && flag; ++j1) {
                        if (i1 >= 0 && i1 < 256) {
                            Block block = world.getBlock(l1, i1, j1);
                            if (block == Blocks.air || block.isLeaves((IBlockAccess)world, l1, i1, j1) || block == Blocks.netherrack || block == Blocks.soul_sand || block == NContent.taintedSoil || block.isWood((IBlockAccess)world, l1, i1, j1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block soil = world.getBlock(xPos, yPos - 1, zPos);
            boolean bl = isSoil = soil != null && soil.canSustainPlant((IBlockAccess)world, xPos, yPos - 1, zPos, ForgeDirection.UP, (IPlantable)NContent.floraSapling) || soil == Blocks.netherrack;
            if (isSoil && yPos < 256 - treeHeight - 1) {
                soil.onPlantGrow(world, xPos, yPos - 1, zPos, xPos, yPos, zPos);
                b0 = 3;
                int b1 = 0;
                for (j1 = yPos - b0 + treeHeight; j1 <= yPos + treeHeight; ++j1) {
                    int k1 = j1 - (yPos + treeHeight);
                    int i2 = b1 + 1 - k1 / 2;
                    for (int j2 = xPos - i2; j2 <= xPos + i2; ++j2) {
                        int k2 = j2 - xPos;
                        for (int l2 = zPos - i2; l2 <= zPos + i2; ++l2) {
                            Block block;
                            int i3 = l2 - zPos;
                            if (Math.abs(k2) == i2 && Math.abs(i3) == i2 && (random.nextInt(2) == 0 || k1 == 0) || (block = world.getBlock(j2, j1, l2)) != null && !block.canBeReplacedByLeaves((IBlockAccess)world, j2, j1, l2)) continue;
                            this.setBlockAndNotifyAdequately(world, j2, j1, l2, (Block)NContent.darkLeaves, random.nextInt(25) == 0 ? 2 : (random.nextInt(15) == 0 ? 1 : 0));
                        }
                    }
                }
                for (j1 = 0; j1 < treeHeight; ++j1) {
                    Block block = world.getBlock(xPos, yPos + j1, zPos);
                    if (block != Blocks.air && block != null && !block.isLeaves((IBlockAccess)world, xPos, yPos + j1, zPos)) continue;
                    this.setBlockAndNotifyAdequately(world, xPos, yPos + j1, zPos, NContent.darkTree, this.metaWood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

