/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class NaturaSeeds
extends ItemSeeds {
    public String[] textureNames = new String[]{"barley", "cotton"};
    public IIcon[] icons;
    public Block blockType;

    public NaturaSeeds(Block cropID, Block soilID) {
        super(cropID, soilID);
        this.blockType = cropID;
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
        this.setHasSubtypes(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + this.textureNames[i] + "_seeds");
        }
    }

    public void getSubItems(Item id, CreativeTabs tab, List list) {
        for (int i = 0; i < this.textureNames.length; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.icons[meta];
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int xPos, int yPos, int zPos, int side, float xClick, float yClick, float zClick) {
        if (side != 1) {
            return false;
        }
        if (player.canPlayerEdit(xPos, yPos, zPos, side, stack) && player.canPlayerEdit(xPos, yPos + 1, zPos, side, stack)) {
            Block soil = world.getBlock(xPos, yPos, zPos);
            if (soil != null && soil.canSustainPlant((IBlockAccess)world, xPos, yPos, zPos, ForgeDirection.UP, (IPlantable)this) && world.isAirBlock(xPos, yPos + 1, zPos)) {
                world.setBlock(xPos, yPos + 1, zPos, this.blockType, stack.getItemDamage() * 4, 3);
                --stack.stackSize;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getUnlocalizedName(ItemStack stack) {
        int arr = MathHelper.clamp_int((int)stack.getItemDamage(), (int)0, (int)this.textureNames.length);
        return "item." + this.textureNames[arr] + ".seed";
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        switch (stack.getItemDamage()) {
            case 0: {
                list.add(StatCollector.translateToLocal((String)"tooltip.barley"));
                break;
            }
            case 1: {
                list.add(StatCollector.translateToLocal((String)"tooltip.cotton"));
            }
        }
    }
}

