/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.recipes;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public class IronShulkerBoxesColoringRecipe
extends CustomRecipe {
    public IronShulkerBoxesColoringRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput craftingInput, Level p_44325_) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < craftingInput.size(); ++k) {
            ItemStack itemstack = craftingInput.getItem(k);
            if (itemstack.isEmpty()) continue;
            if (Block.byItem((Item)itemstack.getItem()) instanceof AbstractIronShulkerBoxBlock) {
                ++i;
            } else {
                if (!itemstack.is(Tags.Items.DYES)) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack itemStack = ItemStack.EMPTY;
        DyeColor dyeColor = DyeColor.WHITE;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStackInInv = craftingInput.getItem(i);
            if (itemStackInInv.isEmpty()) continue;
            Item item = itemStackInInv.getItem();
            if (Block.byItem((Item)item) instanceof AbstractIronShulkerBoxBlock) {
                itemStack = itemStackInInv;
                continue;
            }
            DyeColor tmp = DyeColor.getColor((ItemStack)itemStackInInv);
            if (tmp == null) continue;
            dyeColor = tmp;
        }
        Block block = AbstractIronShulkerBoxBlock.getBlockByColor(dyeColor, AbstractIronShulkerBoxBlock.getTypeFromItem(itemStack.getItem()));
        return itemStack.transmuteCopy((ItemLike)block, 1);
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)IronShulkerBoxesRecipes.SHULKER_BOX_COLORING.get();
    }
}

