/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.item;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CopperShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.item.IronShulkerBoxesUpgradeType;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class IronShulkerBoxUpgradeItem
extends Item {
    private final IronShulkerBoxesUpgradeType type;

    public IronShulkerBoxUpgradeItem(IronShulkerBoxesUpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player entityPlayer = context.getPlayer();
        BlockPos blockPos = context.getClickedPos();
        Level world = context.getLevel();
        ItemStack itemStack = context.getItemInHand();
        boolean passed = false;
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        if (entityPlayer == null) {
            return InteractionResult.PASS;
        }
        if (this.type.canUpgrade(IronShulkerBoxesTypes.VANILLA)) {
            if (world.getBlockState(blockPos).getBlock() instanceof ShulkerBoxBlock) {
                passed = true;
            }
        } else {
            Block block = world.getBlockState(blockPos).getBlock();
            if (!(block instanceof AbstractIronShulkerBoxBlock)) {
                passed = true;
            } else {
                AbstractIronShulkerBoxBlock block2 = (AbstractIronShulkerBoxBlock)block;
                if (block2.defaultBlockState() == IronShulkerBoxesTypes.get(this.type.source, block2.getColor()).defaultBlockState()) {
                    passed = true;
                }
            }
        }
        if (!passed) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (this.type.canUpgrade(IronShulkerBoxesTypes.VANILLA) && !(blockEntity instanceof ShulkerBoxBlockEntity)) {
            return InteractionResult.PASS;
        }
        AbstractIronShulkerBoxBlockEntity newShulkerBox = null;
        Component customName = null;
        NonNullList shulkerBoxContents = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        BlockState iBlockState = ((CopperShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get())).defaultBlockState();
        if (blockEntity != null) {
            if (blockEntity instanceof AbstractIronShulkerBoxBlockEntity) {
                AbstractIronShulkerBoxBlockEntity shulkerBox = (AbstractIronShulkerBoxBlockEntity)blockEntity;
                BlockState shulkerBoxState = world.getBlockState(blockPos);
                if (AbstractIronShulkerBoxBlockEntity.getOpenCount((BlockGetter)world, blockPos) > 0) {
                    return InteractionResult.PASS;
                }
                if (!shulkerBox.canOpen(entityPlayer)) {
                    return InteractionResult.PASS;
                }
                shulkerBoxContents = shulkerBox.getItems();
                Direction shulkerBoxFacing = (Direction)shulkerBoxState.getValue(AbstractIronShulkerBoxBlock.FACING);
                customName = shulkerBox.getCustomName();
                DyeColor shulkerBoxColor = shulkerBox.getColor();
                iBlockState = IronShulkerBoxesTypes.get(this.type.target, shulkerBoxColor).defaultBlockState();
                iBlockState = (BlockState)iBlockState.setValue(AbstractIronShulkerBoxBlock.FACING, (Comparable)shulkerBoxFacing);
                newShulkerBox = this.type.target.makeEntity(blockPos, iBlockState, shulkerBoxColor);
            } else if (blockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)blockEntity;
                BlockState shulkerBoxState = world.getBlockState(blockPos);
                if (!shulkerBox.canOpen(entityPlayer)) {
                    return InteractionResult.PASS;
                }
                if (!this.type.canUpgrade(IronShulkerBoxesTypes.VANILLA)) {
                    return InteractionResult.PASS;
                }
                shulkerBoxContents = NonNullList.withSize((int)shulkerBox.getContainerSize(), (Object)ItemStack.EMPTY);
                for (int slot = 0; slot < shulkerBoxContents.size(); ++slot) {
                    shulkerBoxContents.set(slot, (Object)shulkerBox.getItem(slot));
                }
                Direction shulkerBoxFacing = (Direction)shulkerBoxState.getValue((Property)ShulkerBoxBlock.FACING);
                customName = shulkerBox.getCustomName();
                DyeColor shulkerBoxColor = ((ShulkerBoxBlock)shulkerBoxState.getBlock()).getColor();
                iBlockState = IronShulkerBoxesTypes.get(this.type.target, shulkerBoxColor).defaultBlockState();
                iBlockState = (BlockState)iBlockState.setValue(AbstractIronShulkerBoxBlock.FACING, (Comparable)shulkerBoxFacing);
                shulkerBox.clearContent();
                newShulkerBox = this.type.target.makeEntity(blockPos, iBlockState, shulkerBoxColor);
            }
        }
        if (newShulkerBox == null) {
            return InteractionResult.PASS;
        }
        world.removeBlockEntity(blockPos);
        world.removeBlock(blockPos, false);
        world.setBlock(blockPos, iBlockState, 3);
        world.setBlockEntity(newShulkerBox);
        world.sendBlockUpdated(blockPos, iBlockState, iBlockState, 3);
        BlockEntity tileEntity2 = world.getBlockEntity(blockPos);
        if (tileEntity2 instanceof AbstractIronShulkerBoxBlockEntity) {
            ((AbstractIronShulkerBoxBlockEntity)tileEntity2).setItems((NonNullList<ItemStack>)shulkerBoxContents);
        }
        if (!entityPlayer.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        MutableComponent SOURCE = Component.translatable((String)("ironshulkerbox." + this.type.source.getEnglishName().toLowerCase())).withStyle(ChatFormatting.BOLD);
        MutableComponent TARGET = Component.translatable((String)("ironshulkerbox." + this.type.target.getEnglishName().toLowerCase())).withStyle(ChatFormatting.BOLD);
        pTooltipComponents.add((Component)Component.translatable((String)"item.ironshulkerbox.shulker_box_upgrade.upgrade", (Object[])new Object[]{SOURCE, TARGET}).withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.ironshulkerbox.shulker_box_upgrade.color").withStyle(ChatFormatting.GOLD));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

