/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.data.loot;

import com.google.common.collect.ImmutableSet;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public class IronShulkerBoxesBlockLoot
extends BlockLootSubProvider {
    private static final Set<Item> EXPLOSION_RESISTANT = IronShulkerBoxesBlockLoot.getExplosionResistance().stream().map(ItemLike::asItem).collect(Collectors.toSet());
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();

    public IronShulkerBoxesBlockLoot(HolderLookup.Provider provider) {
        super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.add((Block)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
        this.add((Block)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
        this.add((Block)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
        this.add((Block)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
        this.add((Block)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
        this.add((Block)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
        for (DyeColor color : DyeColor.values()) {
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
            this.add((Block)((DeferredBlock)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get(), x$0 -> this.createShulkerBoxDrop((Block)x$0));
        }
    }

    protected void add(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected static Set<Block> getExplosionResistance() {
        ImmutableSet.Builder blocks = new ImmutableSet.Builder();
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get()));
        blocks.add((Object)((Block)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get()));
        IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.forEach((dyeColor, block) -> blocks.add((Object)((Block)block.get())));
        return blocks.build();
    }
}

