/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.block.entity;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractIronShulkerBoxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private final int[] slots;
    private NonNullList<ItemStack> itemStacks;
    private int openCount;
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    @Nullable
    private final DyeColor color;
    private final IronShulkerBoxesTypes shulkerBoxType;

    public AbstractIronShulkerBoxBlockEntity(BlockEntityType<?> typeIn, BlockPos blockPos, BlockState blockState, @Nullable DyeColor colorIn, IronShulkerBoxesTypes shulkerBoxTypeIn) {
        super(typeIn, blockPos, blockState);
        this.slots = IntStream.range(0, shulkerBoxTypeIn.size).toArray();
        this.itemStacks = NonNullList.withSize((int)shulkerBoxTypeIn.size, (Object)ItemStack.EMPTY);
        this.color = colorIn;
        this.shulkerBoxType = shulkerBoxTypeIn;
    }

    public AbstractIronShulkerBoxBlockEntity(BlockEntityType<?> typeIn, BlockPos blockPos, BlockState blockState, IronShulkerBoxesTypes shulkerBoxTypeIn) {
        super(typeIn, blockPos, blockState);
        this.slots = IntStream.range(0, shulkerBoxTypeIn.size).toArray();
        this.itemStacks = NonNullList.withSize((int)shulkerBoxTypeIn.size, (Object)ItemStack.EMPTY);
        this.color = AbstractIronShulkerBoxBlock.getColorFromBlock(blockState.getBlock());
        this.shulkerBoxType = shulkerBoxTypeIn;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, AbstractIronShulkerBoxBlockEntity pBlockEntity) {
        pBlockEntity.updateAnimation(pLevel, pPos, pState);
    }

    protected void updateAnimation(Level pLevel, BlockPos pPos, BlockState pState) {
        this.progressOld = this.progress;
        switch (this.animationStatus.ordinal()) {
            case 0: {
                this.progress = 0.0f;
                break;
            }
            case 1: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    AbstractIronShulkerBoxBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                this.moveCollidedEntities(pLevel, pPos, pState);
                break;
            }
            case 3: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                AbstractIronShulkerBoxBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                break;
            }
            case 2: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState pState) {
        return Shulker.getProgressAabb((float)1.0f, (Direction)((Direction)pState.getValue((Property)ShulkerBoxBlock.FACING)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction;
        AABB aabb;
        List list;
        if (pState.getBlock() instanceof AbstractIronShulkerBoxBlock && !(list = pLevel.getEntities(null, aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)(direction = (Direction)pState.getValue(AbstractIronShulkerBoxBlock.FACING)), (float)this.progressOld, (float)this.progress).move(pPos))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                entity.move(MoverType.SHULKER_BOX, new Vec3((aabb.getXsize() + 0.01) * (double)direction.getStepX(), (aabb.getYsize() + 0.01) * (double)direction.getStepY(), (aabb.getZsize() + 0.01) * (double)direction.getStepZ()));
            }
        }
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    public boolean triggerEvent(int pId, int pType) {
        if (pId == 1) {
            this.openCount = pType;
            if (pType == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
            }
            if (pType == 1) {
                this.animationStatus = AnimationStatus.OPENING;
            }
            return true;
        }
        return super.triggerEvent(pId, pType);
    }

    private static void doNeighborUpdates(Level pLevel, BlockPos pPos, BlockState pState) {
        pState.updateNeighbourShapes((LevelAccessor)pLevel, pPos, 3);
        pLevel.updateNeighborsAt(pPos, pState.getBlock());
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount == 1) {
                this.level.gameEvent((Entity)pPlayer, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound(null, this.worldPosition, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            --this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.level.gameEvent((Entity)pPlayer, (Holder)GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound((Player)null, this.worldPosition, SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.shulkerBox");
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.loadFromTag(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (!this.trySaveLootTable(pTag)) {
            ContainerHelper.saveAllItems((CompoundTag)pTag, this.itemStacks, (boolean)false, (HolderLookup.Provider)pRegistries);
        }
    }

    public void loadFromTag(CompoundTag pTag, HolderLookup.Provider pLevelRegistry) {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag) && pTag.contains("Items", 9)) {
            ContainerHelper.loadAllItems((CompoundTag)pTag, this.itemStacks, (HolderLookup.Provider)pLevelRegistry);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    public void setItems(NonNullList<ItemStack> itemsIn) {
        this.itemStacks = NonNullList.withSize((int)this.getShulkerBoxType().size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < itemsIn.size(); ++i) {
            if (i >= this.itemStacks.size()) continue;
            this.getItems().set(i, (Object)((ItemStack)itemsIn.get(i)));
        }
    }

    public int[] getSlotsForFace(Direction pSide) {
        return this.slots;
    }

    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return (!(Block.byItem((Item)pItemStack.getItem()) instanceof ShulkerBoxBlock) || !(Block.byItem((Item)pItemStack.getItem()) instanceof AbstractIronShulkerBoxBlock)) && pItemStack.getItem().canFitInsideContainerItems();
    }

    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public float getProgress(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    public IronShulkerBoxesTypes getShulkerBoxType() {
        IronShulkerBoxesTypes typeNew;
        IronShulkerBoxesTypes type = IronShulkerBoxesTypes.IRON;
        if (this.hasLevel() && (typeNew = AbstractIronShulkerBoxBlock.getTypeFromBlock(this.getBlockState().getBlock())) != null) {
            type = typeNew;
        }
        return type;
    }

    public abstract Block getBlockToUse();

    public static int getOpenCount(BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntity blockentity;
        BlockState blockstate = blockGetter.getBlockState(blockPos);
        if (blockstate.hasBlockEntity() && (blockentity = blockGetter.getBlockEntity(blockPos)) instanceof AbstractIronShulkerBoxBlockEntity) {
            return ((AbstractIronShulkerBoxBlockEntity)blockentity).openCount;
        }
        return 0;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

