/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.block;

import com.progwml6.ironshulkerbox.common.Util;
import com.progwml6.ironshulkerbox.common.block.CopperShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CrystalShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.DiamondShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.GoldShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.ObsidianShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.CopperShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.CrystalShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.DiamondShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.GoldShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.IronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.ObsidianShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredBlock;

public enum IronShulkerBoxesTypes implements StringRepresentable
{
    IRON(54, 9, 184, 222, ResourceLocation.fromNamespaceAndPath((String)"ironshulkerbox", (String)"textures/gui/iron_container.png"), 256, 256),
    GOLD(81, 9, 184, 276, ResourceLocation.fromNamespaceAndPath((String)"ironshulkerbox", (String)"textures/gui/gold_container.png"), 256, 276),
    DIAMOND(108, 12, 238, 276, ResourceLocation.fromNamespaceAndPath((String)"ironshulkerbox", (String)"textures/gui/diamond_container.png"), 256, 276),
    COPPER(45, 9, 184, 204, ResourceLocation.fromNamespaceAndPath((String)"ironshulkerbox", (String)"textures/gui/copper_container.png"), 256, 256),
    CRYSTAL(108, 12, 238, 276, ResourceLocation.fromNamespaceAndPath((String)"ironshulkerbox", (String)"textures/gui/diamond_container.png"), 256, 276),
    OBSIDIAN(108, 12, 238, 276, ResourceLocation.fromNamespaceAndPath((String)"ironshulkerbox", (String)"textures/gui/diamond_container.png"), 256, 276),
    VANILLA(0, 0, 0, 0, ResourceLocation.withDefaultNamespace((String)"textures/gui/container/shulker_box.png"), 0, 0);

    private final String name = Util.toEnglishName(this.name());
    public final int size;
    public final int rowLength;
    public final int xSize;
    public final int ySize;
    public final ResourceLocation guiTexture;
    public final int textureXSize;
    public final int textureYSize;

    private IronShulkerBoxesTypes(int size, int rowLength, int xSize, int ySize, ResourceLocation guiTexture, int textureXSize, int textureYSize) {
        this.size = size;
        this.rowLength = rowLength;
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiTexture = guiTexture;
        this.textureXSize = textureXSize;
        this.textureYSize = textureYSize;
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getEnglishName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.getEnglishName();
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public boolean isTransparent() {
        return this == CRYSTAL;
    }

    @Nullable
    public AbstractIronShulkerBoxBlockEntity makeEntity(BlockPos blockPos, BlockState blockState, @Nullable DyeColor color) {
        return switch (this.ordinal()) {
            case 0 -> new IronShulkerBoxBlockEntity(color, blockPos, blockState);
            case 1 -> new GoldShulkerBoxBlockEntity(color, blockPos, blockState);
            case 2 -> new DiamondShulkerBoxBlockEntity(color, blockPos, blockState);
            case 3 -> new CopperShulkerBoxBlockEntity(color, blockPos, blockState);
            case 4 -> new CrystalShulkerBoxBlockEntity(color, blockPos, blockState);
            case 5 -> new ObsidianShulkerBoxBlockEntity(color, blockPos, blockState);
            default -> null;
        };
    }

    public static Block get(IronShulkerBoxesTypes type, @Nullable DyeColor color) {
        if (color == null) {
            return switch (type.ordinal()) {
                case 0 -> (IronShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get());
                case 1 -> (GoldShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get());
                case 2 -> (DiamondShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get());
                case 4 -> (CrystalShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get());
                case 3 -> (CopperShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get());
                case 5 -> (ObsidianShulkerBoxBlock)((Object)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get());
                default -> Blocks.SHULKER_BOX;
            };
        }
        return switch (type.ordinal()) {
            case 0 -> (IronShulkerBoxBlock)((Object)((DeferredBlock)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get());
            case 1 -> (GoldShulkerBoxBlock)((Object)((DeferredBlock)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get());
            case 2 -> (DiamondShulkerBoxBlock)((Object)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get());
            case 4 -> (CrystalShulkerBoxBlock)((Object)((DeferredBlock)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get());
            case 3 -> (CopperShulkerBoxBlock)((Object)((DeferredBlock)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get());
            case 5 -> (ObsidianShulkerBoxBlock)((Object)((DeferredBlock)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get());
            default -> {
                switch (color) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case WHITE: {
                        yield Blocks.WHITE_SHULKER_BOX;
                    }
                    case ORANGE: {
                        yield Blocks.ORANGE_SHULKER_BOX;
                    }
                    case MAGENTA: {
                        yield Blocks.MAGENTA_SHULKER_BOX;
                    }
                    case LIGHT_BLUE: {
                        yield Blocks.LIGHT_BLUE_SHULKER_BOX;
                    }
                    case YELLOW: {
                        yield Blocks.YELLOW_SHULKER_BOX;
                    }
                    case LIME: {
                        yield Blocks.LIME_SHULKER_BOX;
                    }
                    case PINK: {
                        yield Blocks.PINK_SHULKER_BOX;
                    }
                    case GRAY: {
                        yield Blocks.GRAY_SHULKER_BOX;
                    }
                    case LIGHT_GRAY: {
                        yield Blocks.LIGHT_GRAY_SHULKER_BOX;
                    }
                    case CYAN: {
                        yield Blocks.CYAN_SHULKER_BOX;
                    }
                    case PURPLE: {
                        yield Blocks.PURPLE_SHULKER_BOX;
                    }
                    case BLUE: {
                        yield Blocks.BLUE_SHULKER_BOX;
                    }
                    case BROWN: {
                        yield Blocks.BROWN_SHULKER_BOX;
                    }
                    case GREEN: {
                        yield Blocks.GREEN_SHULKER_BOX;
                    }
                    case RED: {
                        yield Blocks.RED_SHULKER_BOX;
                    }
                    case BLACK: 
                }
                yield Blocks.BLACK_SHULKER_BOX;
            }
        };
    }
}

