/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.block;

import com.google.common.collect.Maps;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractIronShulkerBoxBlock
extends BaseEntityBlock {
    private static final Component UNKNOWN_CONTENTS = Component.translatable((String)"container.shulkerBox.unknownContents");
    private static final VoxelShape UP_OPEN_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_OPEN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WES_OPEN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_OPEN_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_OPEN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_OPEN_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> OPEN_SHAPE_BY_DIRECTION = (Map)Util.make((Object)Maps.newEnumMap(Direction.class), p_258974_ -> {
        p_258974_.put(Direction.NORTH, NORTH_OPEN_AABB);
        p_258974_.put(Direction.EAST, EAST_OPEN_AABB);
        p_258974_.put(Direction.SOUTH, SOUTH_OPEN_AABB);
        p_258974_.put(Direction.WEST, WES_OPEN_AABB);
        p_258974_.put(Direction.UP, UP_OPEN_AABB);
        p_258974_.put(Direction.DOWN, DOWN_OPEN_AABB);
    });
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace((String)"contents");
    private final IronShulkerBoxesTypes type;
    @Nullable
    protected final DyeColor color;
    protected final Supplier<BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>> blockEntityType;

    public AbstractIronShulkerBoxBlock(BlockBehaviour.Properties properties, @Nullable DyeColor color, Supplier<BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity>> blockEntityType, IronShulkerBoxesTypes type) {
        super(properties);
        this.color = color;
        this.type = type;
        this.blockEntityType = blockEntityType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.UP));
    }

    public BlockEntityType<? extends AbstractIronShulkerBoxBlockEntity> blockEntityType() {
        return this.blockEntityType.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return AbstractIronShulkerBoxBlock.createTickerHelper(pBlockEntityType, this.blockEntityType(), AbstractIronShulkerBoxBlockEntity::tick);
    }

    @Deprecated
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.isSpectator()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
            AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockentity;
            if (AbstractIronShulkerBoxBlock.canOpen(pState, pLevel, pPos, ironShulkerBoxBlockEntity)) {
                pPlayer.openMenu((MenuProvider)ironShulkerBoxBlockEntity);
                pPlayer.awardStat(Stats.OPEN_SHULKER_BOX);
                PiglinAi.angerNearbyPiglins((Player)pPlayer, (boolean)true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static boolean canOpen(BlockState pState, Level pLevel, BlockPos pPos, AbstractIronShulkerBoxBlockEntity pBlockEntity) {
        if (pBlockEntity.getAnimationStatus() != AbstractIronShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)((Direction)pState.getValue(FACING)), (float)0.0f, (float)0.5f).move(pPos).deflate(1.0E-6);
        return pLevel.noCollision(aabb);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)pContext.getClickedFace());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
            AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockentity;
            if (!pLevel.isClientSide && pPlayer.isCreative() && !ironShulkerBoxBlockEntity.isEmpty()) {
                ItemStack itemstack = AbstractIronShulkerBoxBlock.getColoredItemStack(this.getColor(), this.getType());
                itemstack.applyComponents(blockentity.collectComponents());
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                pLevel.addFreshEntity((Entity)itementity);
            } else {
                ironShulkerBoxBlockEntity.unpackLootTable(pPlayer);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    @Deprecated
    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        BlockEntity blockentity = (BlockEntity)pParams.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
            AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockentity;
            pParams = pParams.withDynamicDrop(CONTENTS, itemStackConsumer -> {
                for (int i = 0; i < ironShulkerBoxBlockEntity.getContainerSize(); ++i) {
                    itemStackConsumer.accept(ironShulkerBoxBlockEntity.getItem(i));
                }
            });
        }
        return super.getDrops(pState, pParams);
    }

    @Deprecated
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof AbstractIronShulkerBoxBlockEntity) {
                pLevel.updateNeighbourForOutputSignal(pPos, pState.getBlock());
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        if (pStack.has(DataComponents.CONTAINER_LOOT)) {
            pTootipComponents.add(UNKNOWN_CONTENTS);
        }
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : ((ItemContainerContents)pStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
            ++j;
            if (i > 4) continue;
            ++i;
            pTootipComponents.add((Component)Component.translatable((String)"container.shulkerBox.itemCount", (Object[])new Object[]{itemstack.getHoverName(), itemstack.getCount()}));
        }
        if (j - i > 0) {
            pTootipComponents.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).withStyle(ChatFormatting.ITALIC));
        }
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        AbstractIronShulkerBoxBlockEntity ironShulkerBoxBlockEntity;
        BlockEntity blockEntity = pReader.getBlockEntity(pPos);
        if (blockEntity instanceof AbstractIronShulkerBoxBlockEntity && !(ironShulkerBoxBlockEntity = (AbstractIronShulkerBoxBlockEntity)blockEntity).isClosed()) {
            return OPEN_SHAPE_BY_DIRECTION.get(((Direction)pState.getValue(FACING)).getOpposite());
        }
        return Shapes.block();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        return blockentity instanceof AbstractIronShulkerBoxBlockEntity ? Shapes.create((AABB)((AbstractIronShulkerBoxBlockEntity)blockentity).getBoundingBox(pState)) : Shapes.block();
    }

    protected boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Container)pLevel.getBlockEntity(pPos)));
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        ItemStack itemstack = super.getCloneItemStack(pLevel, pPos, pState);
        pLevel.getBlockEntity(pPos, this.blockEntityType()).ifPresent(shulkerBoxBlockEntity -> shulkerBoxBlockEntity.saveToItem(itemstack, (HolderLookup.Provider)pLevel.registryAccess()));
        return itemstack;
    }

    public static IronShulkerBoxesTypes getTypeFromItem(Item itemIn) {
        return AbstractIronShulkerBoxBlock.getTypeFromBlock(Block.byItem((Item)itemIn));
    }

    public static IronShulkerBoxesTypes getTypeFromBlock(Block blockIn) {
        return blockIn instanceof AbstractIronShulkerBoxBlock ? ((AbstractIronShulkerBoxBlock)blockIn).getType() : IronShulkerBoxesTypes.VANILLA;
    }

    public IronShulkerBoxesTypes getType() {
        return this.type;
    }

    @Nullable
    public static DyeColor getColorFromItem(Item itemIn) {
        return AbstractIronShulkerBoxBlock.getColorFromBlock(Block.byItem((Item)itemIn));
    }

    @Nullable
    public static DyeColor getColorFromBlock(Block pBlock) {
        return pBlock instanceof AbstractIronShulkerBoxBlock ? ((AbstractIronShulkerBoxBlock)pBlock).getColor() : null;
    }

    public static Block getBlockByColor(@Nullable DyeColor colorIn, IronShulkerBoxesTypes typeIn) {
        return IronShulkerBoxesTypes.get(typeIn, colorIn);
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor pColor, IronShulkerBoxesTypes typeIn) {
        return new ItemStack((ItemLike)AbstractIronShulkerBoxBlock.getBlockByColor(pColor, typeIn));
    }

    @Deprecated
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRot.rotate((Direction)pState.getValue(FACING)));
    }

    @Deprecated
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue(FACING)));
    }
}

