/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.progwml6.ironshulkerbox.client.model.IronShulkerBoxesModels;
import com.progwml6.ironshulkerbox.client.model.inventory.ModelItem;
import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.ICrystalShulkerBox;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class IronShulkerBoxRenderer
implements BlockEntityRenderer<AbstractIronShulkerBoxBlockEntity> {
    private final ShulkerModel<?> model;
    private final BlockEntityRenderDispatcher renderer;
    private static final List<ModelItem> MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));

    public IronShulkerBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ShulkerModel(context.bakeLayer(ModelLayers.SHULKER));
        this.renderer = context.getBlockEntityRenderDispatcher();
    }

    public void render(AbstractIronShulkerBoxBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        DyeColor dyecolor;
        Level level;
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (pBlockEntity.hasLevel() && pBlockEntity.getLevel() != null && (blockstate = pBlockEntity.getLevel().getBlockState(pBlockEntity.getBlockPos())).getBlock() instanceof AbstractIronShulkerBoxBlock) {
            direction = (Direction)blockstate.getValue(AbstractIronShulkerBoxBlock.FACING);
        }
        boolean useTileEntityBlockState = (level = pBlockEntity.getLevel()) != null;
        BlockState blockState = useTileEntityBlockState ? pBlockEntity.getBlockState() : (BlockState)pBlockEntity.getBlockToUse().defaultBlockState().setValue(AbstractIronShulkerBoxBlock.FACING, (Comparable)Direction.UP);
        Block block = blockState.getBlock();
        IronShulkerBoxesTypes boxType = IronShulkerBoxesTypes.IRON;
        IronShulkerBoxesTypes typeFromTileEntity = pBlockEntity.getShulkerBoxType();
        IronShulkerBoxesTypes typeFromBlock = AbstractIronShulkerBoxBlock.getTypeFromBlock(block);
        if (typeFromTileEntity != null) {
            boxType = typeFromTileEntity;
        }
        if ((boxType != typeFromBlock || typeFromTileEntity != typeFromBlock) && typeFromBlock != null) {
            boxType = typeFromBlock;
        }
        Material material = (dyecolor = pBlockEntity.getColor()) == null ? new Material(Sheets.SHULKER_SHEET, IronShulkerBoxesModels.chooseShulkerBoxTexture(boxType)) : new Material(Sheets.SHULKER_SHEET, IronShulkerBoxesModels.chooseShulkerBoxTexture(boxType, dyecolor.getId()));
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.5f, 0.5f);
        pPoseStack.scale(0.9995f, 0.9995f, 0.9995f);
        pPoseStack.mulPose(direction.getRotation());
        pPoseStack.scale(1.0f, -1.0f, -1.0f);
        pPoseStack.translate(0.0f, -1.0f, 0.0f);
        ModelPart modelpart = this.model.getLid();
        modelpart.setPos(0.0f, 24.0f - pBlockEntity.getProgress(pPartialTick) * 0.5f * 16.0f, 0.0f);
        modelpart.yRot = 270.0f * pBlockEntity.getProgress(pPartialTick) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.buffer(pBuffer, RenderType::entityCutoutNoCull);
        this.model.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.popPose();
        if (boxType.isTransparent() && pBlockEntity instanceof ICrystalShulkerBox) {
            ICrystalShulkerBox crystalShulkerBox = (ICrystalShulkerBox)((Object)pBlockEntity);
            if (Vec3.atCenterOf((Vec3i)pBlockEntity.getBlockPos()).closerThan((Position)this.renderer.camera.getPosition(), 128.0)) {
                float rotation = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - pPartialTick;
                for (int j = 0; j < MODEL_ITEMS.size() - 1; ++j) {
                    IronShulkerBoxRenderer.renderItem(pPoseStack, pBuffer, (ItemStack)crystalShulkerBox.getTopItems().get(j), MODEL_ITEMS.get(j), rotation, pPackedLight);
                }
            }
        }
    }

    public static void renderItem(PoseStack matrices, MultiBufferSource buffer, ItemStack item, ModelItem modelItem, float rotation, int light) {
        if (item.isEmpty()) {
            return;
        }
        matrices.pushPose();
        Vector3f center = modelItem.getCenter();
        matrices.translate(center.x(), center.y(), center.z());
        matrices.mulPose(Axis.YP.rotationDegrees(rotation));
        float scale = modelItem.getSizeScaled();
        matrices.scale(scale, scale, scale);
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, matrices, buffer, null, 0);
        matrices.popPose();
    }

    public AABB getRenderBoundingBox(AbstractIronShulkerBoxBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5, (double)pos.getX() + 1.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 1.5);
    }
}

