/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CopperShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.CrystalShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.DiamondShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.GoldShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.ObsidianShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.creativetabs.IronShulkerBoxesCreativeTabs;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesBlockTags;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesLanguageProvider;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesRecipeProvider;
import com.progwml6.ironshulkerbox.common.data.IronShulkerBoxesSpriteSourceProvider;
import com.progwml6.ironshulkerbox.common.data.loot.IronShulkerBoxesLootTableProvider;
import com.progwml6.ironshulkerbox.common.network.TopStacksSyncPacket;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlockEntityTypes;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesItems;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesMenuTypes;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesRecipes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.stats.Stats;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredBlock;

@Mod(value="ironshulkerbox")
public class IronShulkerBoxes {
    public static final String MODID = "ironshulkerbox";
    private static CauldronInteraction SHULKER_BOX = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
        Block block = Block.byItem((Item)itemStack.getItem());
        if (!(block instanceof AbstractIronShulkerBoxBlock)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            IronShulkerBoxesTypes type = AbstractIronShulkerBoxBlock.getTypeFromBlock(block);
            ItemStack newItemStack = itemStack.transmuteCopy((ItemLike)Blocks.SHULKER_BOX, 1);
            if (type != null) {
                newItemStack = switch (type) {
                    default -> throw new MatchException(null, null);
                    case IronShulkerBoxesTypes.IRON -> itemStack.transmuteCopy((ItemLike)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get(), 1);
                    case IronShulkerBoxesTypes.GOLD -> itemStack.transmuteCopy((ItemLike)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get(), 1);
                    case IronShulkerBoxesTypes.DIAMOND -> itemStack.transmuteCopy((ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), 1);
                    case IronShulkerBoxesTypes.COPPER -> itemStack.transmuteCopy((ItemLike)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get(), 1);
                    case IronShulkerBoxesTypes.CRYSTAL -> itemStack.transmuteCopy((ItemLike)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get(), 1);
                    case IronShulkerBoxesTypes.OBSIDIAN -> itemStack.transmuteCopy((ItemLike)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get(), 1);
                    case IronShulkerBoxesTypes.VANILLA -> itemStack.transmuteCopy((ItemLike)Blocks.SHULKER_BOX, 1);
                };
            }
            player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)newItemStack, (boolean)false));
            player.awardStat(Stats.CLEAN_SHULKER_BOX);
            LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)blockPos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    };

    public IronShulkerBoxes(IEventBus modEventBus) {
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::setupPackets);
        modEventBus.addListener(this::registerCapabilities);
        IronShulkerBoxesBlocks.BLOCKS.register(modEventBus);
        IronShulkerBoxesItems.ITEMS.register(modEventBus);
        IronShulkerBoxesBlockEntityTypes.BLOCK_ENTITIES.register(modEventBus);
        IronShulkerBoxesMenuTypes.MENU_TYPES.register(modEventBus);
        IronShulkerBoxesRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        IronShulkerBoxesCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)((IronShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((GoldShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((DiamondShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((CopperShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((CrystalShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((ObsidianShulkerBoxBlock)((Object)((Object)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            for (DyeColor color : DyeColor.values()) {
                CauldronInteraction.WATER.map().put(((IronShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get()))).asItem(), SHULKER_BOX);
                CauldronInteraction.WATER.map().put(((GoldShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get()))).asItem(), SHULKER_BOX);
                CauldronInteraction.WATER.map().put(((DiamondShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get()))).asItem(), SHULKER_BOX);
                CauldronInteraction.WATER.map().put(((CopperShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get()))).asItem(), SHULKER_BOX);
                CauldronInteraction.WATER.map().put(((CrystalShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get()))).asItem(), SHULKER_BOX);
                CauldronInteraction.WATER.map().put(((ObsidianShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get()))).asItem(), SHULKER_BOX);
                DispenserBlock.registerBehavior((ItemLike)((IronShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.registerBehavior((ItemLike)((GoldShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.registerBehavior((ItemLike)((DiamondShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.registerBehavior((ItemLike)((CopperShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.registerBehavior((ItemLike)((CrystalShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
                DispenserBlock.registerBehavior((ItemLike)((ObsidianShulkerBoxBlock)((Object)((Object)((DeferredBlock)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get()))).asItem(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            }
        });
    }

    private void gatherData(GatherDataEvent event) {
        ExistingFileHelper ext = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new IronShulkerBoxesLootTableProvider(packOutput, lookupProvider));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesRecipeProvider(packOutput, lookupProvider));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesSpriteSourceProvider(packOutput, ext, lookupProvider));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesBlockTags(packOutput, lookupProvider, ext));
        gen.addProvider(event.includeClient(), (DataProvider)new IronShulkerBoxesLanguageProvider(packOutput, "en_us"));
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playBidirectional(TopStacksSyncPacket.TYPE, TopStacksSyncPacket.STREAM_CODEC, TopStacksSyncPacket::handle);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)IronShulkerBoxesBlockEntityTypes.IRON_SHULKER_BOX.get(), (shulkerBox, side) -> new SidedInvWrapper((WorldlyContainer)shulkerBox, null));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)IronShulkerBoxesBlockEntityTypes.GOLD_SHULKER_BOX.get(), (shulkerBox, side) -> new SidedInvWrapper((WorldlyContainer)shulkerBox, null));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)IronShulkerBoxesBlockEntityTypes.DIAMOND_SHULKER_BOX.get(), (shulkerBox, side) -> new SidedInvWrapper((WorldlyContainer)shulkerBox, null));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)IronShulkerBoxesBlockEntityTypes.COPPER_SHULKER_BOX.get(), (shulkerBox, side) -> new SidedInvWrapper((WorldlyContainer)shulkerBox, null));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)IronShulkerBoxesBlockEntityTypes.CRYSTAL_SHULKER_BOX.get(), (shulkerBox, side) -> new SidedInvWrapper((WorldlyContainer)shulkerBox, null));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)IronShulkerBoxesBlockEntityTypes.OBSIDIAN_SHULKER_BOX.get(), (shulkerBox, side) -> new SidedInvWrapper((WorldlyContainer)shulkerBox, null));
        IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.forEach((dyeColor, block) -> event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.IRON.size), new ItemLike[]{(ItemLike)block.get()}));
        IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.forEach((dyeColor, block) -> event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.GOLD.size), new ItemLike[]{(ItemLike)block.get()}));
        IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.forEach((dyeColor, block) -> event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.DIAMOND.size), new ItemLike[]{(ItemLike)block.get()}));
        IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.forEach((dyeColor, block) -> event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.COPPER.size), new ItemLike[]{(ItemLike)block.get()}));
        IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.forEach((dyeColor, block) -> event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.CRYSTAL.size), new ItemLike[]{(ItemLike)block.get()}));
        IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.forEach((dyeColor, block) -> event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.OBSIDIAN.size), new ItemLike[]{(ItemLike)block.get()}));
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.IRON.size), new ItemLike[]{(ItemLike)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get()});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.GOLD.size), new ItemLike[]{(ItemLike)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get()});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.DIAMOND.size), new ItemLike[]{(ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get()});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.COPPER.size), new ItemLike[]{(ItemLike)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get()});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.CRYSTAL.size), new ItemLike[]{(ItemLike)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get()});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, IronShulkerBoxesTypes.OBSIDIAN.size), new ItemLike[]{(ItemLike)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get()});
    }
}

