/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.jei;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public final class ShulkerBoxColoringRecipeMaker {
    private static final String group = "ironshulkerboxes.shulker.color";

    public static List<RecipeHolder<CraftingRecipe>> createRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> list = new ArrayList<RecipeHolder<CraftingRecipe>>();
        for (IronShulkerBoxesTypes type : IronShulkerBoxesTypes.values()) {
            if (type == IronShulkerBoxesTypes.VANILLA) continue;
            ItemStack baseShulkerStack = new ItemStack((ItemLike)IronShulkerBoxesTypes.get(type, null));
            Ingredient baseShulkerIngredient = Ingredient.of((ItemStack[])new ItemStack[]{baseShulkerStack});
            list.addAll(Arrays.stream(DyeColor.values()).map(color -> {
                DyeItem dye = DyeItem.byColor((DyeColor)color);
                ItemStack dyeStack = new ItemStack((ItemLike)dye);
                TagKey colorTag = color.getTag();
                Ingredient.ItemValue dyeList = new Ingredient.ItemValue(dyeStack);
                Ingredient.TagValue colorList = new Ingredient.TagValue(colorTag);
                Stream<Ingredient.Value> colorIngredientStream = Stream.of(dyeList, colorList);
                Ingredient colorIngredient = Ingredient.fromValues(colorIngredientStream);
                NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseShulkerIngredient, colorIngredient});
                ItemStack output = AbstractIronShulkerBoxBlock.getColoredItemStack(color, AbstractIronShulkerBoxBlock.getTypeFromItem(baseShulkerStack.getItem()));
                ResourceLocation id = new ResourceLocation("ironshulkerbox", "ironshulkerboxes.shulker.color." + output.getDescriptionId());
                ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs);
                return new RecipeHolder(id, (Recipe)recipe);
            }).toList());
        }
        return list;
    }

    private ShulkerBoxColoringRecipeMaker() {
    }
}

