/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.item;

import com.progwml6.ironshulkerbox.client.model.inventory.IronShulkerBoxItemStackRenderer;
import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.CopperShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.CrystalShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.DiamondShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.GoldShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.IronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.ObsidianShulkerBoxBlockEntity;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class IronShulkerBoxBlockItem
extends BlockItem {
    protected IronShulkerBoxesTypes type;
    protected DyeColor color;

    public IronShulkerBoxBlockItem(Block block, Item.Properties properties, IronShulkerBoxesTypes type, DyeColor color) {
        super(block, properties);
        this.type = type;
        this.color = color;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                DyeColor dyeColor = IronShulkerBoxBlockItem.this.color != null ? IronShulkerBoxBlockItem.this.color : null;
                return new IronShulkerBoxItemStackRenderer<BlockEntity>(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels(), switch (IronShulkerBoxBlockItem.this.type) {
                    case IronShulkerBoxesTypes.GOLD -> () -> new GoldShulkerBoxBlockEntity(BlockPos.ZERO, IronShulkerBoxesTypes.get(IronShulkerBoxBlockItem.this.type, dyeColor).defaultBlockState());
                    case IronShulkerBoxesTypes.DIAMOND -> () -> new DiamondShulkerBoxBlockEntity(BlockPos.ZERO, IronShulkerBoxesTypes.get(IronShulkerBoxBlockItem.this.type, dyeColor).defaultBlockState());
                    case IronShulkerBoxesTypes.COPPER -> () -> new CopperShulkerBoxBlockEntity(BlockPos.ZERO, IronShulkerBoxesTypes.get(IronShulkerBoxBlockItem.this.type, dyeColor).defaultBlockState());
                    case IronShulkerBoxesTypes.CRYSTAL -> () -> new CrystalShulkerBoxBlockEntity(BlockPos.ZERO, IronShulkerBoxesTypes.get(IronShulkerBoxBlockItem.this.type, dyeColor).defaultBlockState());
                    case IronShulkerBoxesTypes.OBSIDIAN -> () -> new ObsidianShulkerBoxBlockEntity(BlockPos.ZERO, IronShulkerBoxesTypes.get(IronShulkerBoxBlockItem.this.type, dyeColor).defaultBlockState());
                    default -> () -> new IronShulkerBoxBlockEntity(BlockPos.ZERO, IronShulkerBoxesTypes.get(IronShulkerBoxBlockItem.this.type, dyeColor).defaultBlockState());
                });
            }
        });
    }

    public boolean canFitInsideContainerItems() {
        return !(this.getBlock() instanceof AbstractIronShulkerBoxBlock);
    }
}

