/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.data;

import com.progwml6.ironshulkerbox.common.item.IronShulkerBoxesUpgradeType;
import com.progwml6.ironshulkerbox.common.recipes.IronShulkerBoxesColoringRecipe;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesItems;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class IronShulkerBoxesRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public IronShulkerBoxesRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.addDefaultShulkerBoxRecipes(recipeOutput);
        this.addColoredShulkerBoxRecipes(recipeOutput);
        this.addUpgradesRecipes(recipeOutput);
        SpecialRecipeBuilder.special(IronShulkerBoxesColoringRecipe::new).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulker_box_coloring").toString());
    }

    private void addDefaultShulkerBoxRecipes(RecipeOutput recipeOutput) {
        String color = "default/";
        String group = "ironshulkerbox:shulker_box";
        this.registerCopperBoxRecipe(recipeOutput, (ItemLike)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get(), (ItemLike)Items.SHULKER_BOX, color, group);
        this.registerIronBoxRecipe(recipeOutput, (ItemLike)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.COPPER_SHULKER_BOX.get(), (ItemLike)Items.SHULKER_BOX, color, group);
        this.registerGoldBoxRecipe(recipeOutput, (ItemLike)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.IRON_SHULKER_BOX.get(), color, group);
        this.registerDiamondBoxRecipe(recipeOutput, (ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.GOLD_SHULKER_BOX.get(), color, group);
        this.registerCrystalBoxRecipe(recipeOutput, (ItemLike)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), color, group);
        this.registerObsidianBoxRecipe(recipeOutput, (ItemLike)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOX.get(), (ItemLike)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOX.get(), color, group);
    }

    private void addColoredShulkerBoxRecipes(RecipeOutput recipeOutput) {
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.name().toLowerCase(Locale.ROOT);
            String folder = colorName + "/";
            String group = "ironshulkerbox:" + colorName + "_shulker_box";
            this.registerCopperBoxRecipe(recipeOutput, (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get(), this.getShulkerBoxItem(color), folder, group);
            this.registerIronBoxRecipe(recipeOutput, (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.COPPER_SHULKER_BOXES.get((Object)color)).get(), this.getShulkerBoxItem(color), folder, group);
            this.registerGoldBoxRecipe(recipeOutput, (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.IRON_SHULKER_BOXES.get((Object)color)).get(), folder, group);
            this.registerDiamondBoxRecipe(recipeOutput, (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.GOLD_SHULKER_BOXES.get((Object)color)).get(), folder, group);
            this.registerCrystalBoxRecipe(recipeOutput, (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), folder, group);
            this.registerObsidianBoxRecipe(recipeOutput, (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.OBSIDIAN_SHULKER_BOXES.get((Object)color)).get(), (ItemLike)((DeferredBlock)IronShulkerBoxesBlocks.DIAMOND_SHULKER_BOXES.get((Object)color)).get(), folder, group);
        }
    }

    private void addUpgradesRecipes(RecipeOutput recipeOutput) {
        String folder = "upgrades/";
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_COPPER)).get())).define(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_copper_ingot", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_COPPER)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_IRON)).get())).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_iron_ingot", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.VANILLA_TO_IRON)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.COPPER_TO_IRON)).get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('G'), Tags.Items.GLASS).pattern("IGI").pattern("GCG").pattern("IGI").unlockedBy("has_iron_ingot", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.COPPER_TO_IRON)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.IRON_TO_GOLD)).get())).define(Character.valueOf('S'), Tags.Items.INGOTS_IRON).define(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).pattern("MSM").pattern("MMM").pattern("MMM").unlockedBy("has_iron_ingot", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.IRON_TO_GOLD)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.GOLD_TO_DIAMOND)).get())).define(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('G'), Tags.Items.GLASS).pattern("GMG").pattern("GSG").pattern("GMG").unlockedBy("has_glass", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.GLASS)).save(recipeOutput, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.GOLD_TO_DIAMOND)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_OBSIDIAN)).get())).define(Character.valueOf('M'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('G'), Tags.Items.GLASS).pattern("MGM").pattern("MMM").pattern("MMM").unlockedBy("has_glass", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.GLASS)).save(recipeOutput, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_OBSIDIAN)).get(), folder));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_CRYSTAL)).get())).define(Character.valueOf('S'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('G'), Tags.Items.GLASS).pattern("GSG").pattern("GGG").pattern("GGG").unlockedBy("has_glass", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.GLASS)).save(recipeOutput, IronShulkerBoxesRecipeProvider.prefix((ItemLike)((DeferredItem)IronShulkerBoxesItems.UPGRADES.get((Object)IronShulkerBoxesUpgradeType.DIAMOND_TO_CRYSTAL)).get(), folder));
    }

    protected static ResourceLocation prefix(ItemLike item, String prefix) {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getResourceKey((Object)item.asItem()).map(ResourceKey::location).orElseThrow(() -> new IllegalStateException("Could not retrieve registry name for output."));
        return IronShulkerBoxesRecipeProvider.location(prefix + registryName.getPath());
    }

    private static ResourceLocation location(String id) {
        return new ResourceLocation("ironshulkerbox", id);
    }

    private void registerCopperBoxRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).group(group).define(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('S'), input).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_copper", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "copper/vanilla_copper_shulker_box"));
    }

    private void registerIronBoxRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike input, ItemLike inputTwo, String color, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).group(group).define(Character.valueOf('G'), Tags.Items.GLASS).define(Character.valueOf('S'), input).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).pattern("MGM").pattern("GSG").pattern("MGM").unlockedBy("has_gold", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "iron/copper_iron_shulker_box"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).group(group).define(Character.valueOf('S'), inputTwo).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_gold", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_GOLD)).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "iron/vanilla_iron_shulker_box"));
    }

    private void registerGoldBoxRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).group(group).define(Character.valueOf('S'), input).define(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_gold", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.INGOTS_GOLD)).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "gold/iron_gold_shulker_box"));
    }

    private void registerDiamondBoxRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).group(group).define(Character.valueOf('G'), Tags.Items.GLASS).define(Character.valueOf('S'), input).define(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).pattern("GGG").pattern("MSM").pattern("GGG").unlockedBy("has_diamonds", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "diamond/gold_diamond_shulker_box"));
    }

    private void registerCrystalBoxRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).group(group).define(Character.valueOf('G'), Tags.Items.GLASS).define(Character.valueOf('S'), input).pattern("GGG").pattern("GSG").pattern("GGG").unlockedBy("has_glass", IronShulkerBoxesRecipeProvider.has((TagKey)Tags.Items.GLASS)).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "crystal/diamond_crystal_shulker_box"));
    }

    private void registerObsidianBoxRecipe(RecipeOutput recipeOutput, ItemLike result, ItemLike input, String color, String group) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).group(group).define(Character.valueOf('M'), (ItemLike)Items.OBSIDIAN).define(Character.valueOf('S'), input).pattern("MMM").pattern("MSM").pattern("MMM").unlockedBy("has_obsidian", IronShulkerBoxesRecipeProvider.has((ItemLike)Items.OBSIDIAN)).save(recipeOutput, IronShulkerBoxesRecipeProvider.location("shulkerboxes/" + color + "obsidian/diamond_obsidian_shulker_box"));
    }

    private ItemLike getShulkerBoxItem(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Items.WHITE_SHULKER_BOX;
            case DyeColor.ORANGE -> Items.ORANGE_SHULKER_BOX;
            case DyeColor.MAGENTA -> Items.MAGENTA_SHULKER_BOX;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_SHULKER_BOX;
            case DyeColor.YELLOW -> Items.YELLOW_SHULKER_BOX;
            case DyeColor.LIME -> Items.LIME_SHULKER_BOX;
            case DyeColor.PINK -> Items.PINK_SHULKER_BOX;
            case DyeColor.GRAY -> Items.GRAY_SHULKER_BOX;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_SHULKER_BOX;
            case DyeColor.CYAN -> Items.CYAN_SHULKER_BOX;
            case DyeColor.PURPLE -> Items.PURPLE_SHULKER_BOX;
            case DyeColor.BLUE -> Items.BLUE_SHULKER_BOX;
            case DyeColor.BROWN -> Items.BROWN_SHULKER_BOX;
            case DyeColor.GREEN -> Items.GREEN_SHULKER_BOX;
            case DyeColor.RED -> Items.RED_SHULKER_BOX;
            case DyeColor.BLACK -> Items.BLACK_SHULKER_BOX;
        };
    }
}

