package slimeknights.tconstruct.world.block;

import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockSlime extends net.minecraft.block.BlockSlime {
  public static final PropertyEnum<SlimeType> TYPE = PropertyEnum.func_177709_a("type", SlimeType.class);

  public BlockSlime() {
    this.func_149647_a(TinkerRegistry.tabWorld);
    this.func_149649_H();
    this.func_149672_a(field_176231_q);
  }

  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(SlimeType type : SlimeType.values()) {
      list.add(new ItemStack(this, 1, type.meta));
    }
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, TYPE);
  }

  @Override
  public IBlockState func_176203_a(int meta) {
    return this.func_176223_P().func_177226_a(TYPE, SlimeType.fromMeta(meta));
  }

  @Override
  public int func_176201_c(IBlockState state) {
    return ((SlimeType) state.func_177229_b(TYPE)).meta;
  }

  @Override
  public int func_180651_a(IBlockState state) {
    return func_176201_c(state);
  }

  public enum SlimeType implements IStringSerializable {
    GREEN,
    BLUE,
    PURPLE,
    BLOOD,
    MAGMA;

    SlimeType() {
      this.meta = this.ordinal();
    }

    public final int meta;

    public static SlimeType fromMeta(int meta) {
      if(meta < 0 || meta >= values().length) {
        meta = 0;
      }

      return values()[meta];
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }
  }
}
