package slimeknights.tconstruct.tools.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetHandlerPlayServer;

import io.netty.buffer.ByteBuf;
import slimeknights.mantle.network.AbstractPacketThreadsafe;

public class EntityMovementChangePacket extends AbstractPacketThreadsafe {
  public int entityID;
  public double x;
  public double y;
  public double z;
  public float yaw;
  public float pitch;

  public EntityMovementChangePacket() {
  }

  public EntityMovementChangePacket(Entity entity) {
    this.entityID = entity.func_145782_y();
    this.x = entity.field_70159_w;
    this.y = entity.field_70181_x;
    this.z = entity.field_70179_y;
    this.yaw = entity.field_70177_z;
    this.pitch = entity.field_70125_A;
  }

  @Override
  public void handleClientSafe(NetHandlerPlayClient netHandler) {
    Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
    if(entity != null) {
      entity.field_70159_w = x;
      entity.field_70181_x = y;
      entity.field_70179_y = z;
      entity.field_70177_z = yaw;
      entity.field_70125_A = pitch;
    }
  }

  @Override
  public void handleServerSafe(NetHandlerPlayServer netHandler) {
    // only ever sent to clients
    throw new UnsupportedOperationException("Serverside only");
  }

  @Override
  public void fromBytes(ByteBuf buf) {
    this.entityID = buf.readInt();
    this.x = buf.readDouble();
    this.y = buf.readDouble();
    this.z = buf.readDouble();
    this.yaw = buf.readFloat();
    this.pitch = buf.readFloat();
  }

  @Override
  public void toBytes(ByteBuf buf) {
    buf.writeInt(entityID);
    buf.writeDouble(x);
    buf.writeDouble(y);
    buf.writeDouble(z);
    buf.writeFloat(yaw);
    buf.writeFloat(pitch);
  }
}
