package slimeknights.tconstruct.tools.inventory;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntityChest;

import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.tileentity.TileCraftingStation;

// nearly the same as ContainerWorkbench but uses the TileEntities inventory
public class ContainerCraftingStation extends ContainerTinkerStation<TileCraftingStation> {

  public InventoryCraftingPersistent craftMatrix;
  public IInventory craftResult;

  public ContainerCraftingStation(InventoryPlayer playerInventory, TileCraftingStation tile) {
    super(tile);

    craftResult = new InventoryCraftResult();
    craftMatrix = new InventoryCraftingPersistent(this, tile, 3, 3);

    this.func_75146_a(new SlotCrafting(playerInventory.field_70458_d, this.craftMatrix, this.craftResult, 0, 124, 35));
    int i;
    int j;

    for(i = 0; i < 3; ++i) {
      for(j = 0; j < 3; ++j) {
        this.func_75146_a(new Slot(this.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18));
      }
    }

    TileEntityChest chest = detectTE(TileEntityChest.class);
    // TE present?
    if(chest != null) {
      Block blockChest = world.func_180495_p(chest.func_174877_v()).func_177230_c();
      // It's a chest?
      if(blockChest instanceof BlockChest) {
        IInventory inventory = ((BlockChest) blockChest).func_180676_d(world, chest.func_174877_v());
        if(inventory != null) {
          Container sideInventory = new ContainerSideInventory(chest, inventory, -6 - 18 * 6, 8, 6);

          addSubContainer(sideInventory, false);
        }
      }
    }

    this.addPlayerInventory(playerInventory, 8, 84);

    this.func_75130_a(this.craftMatrix);
  }

  // update crafting
  public void func_75130_a(IInventory inventoryIn) {
    this.craftResult
        .func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, this.world));
  }

  public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
    return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
  }


}
