package slimeknights.tconstruct.tools.client;

import com.google.common.collect.Lists;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.client.module.GuiButtonsPartCrafter;
import slimeknights.tconstruct.tools.client.module.GuiInfoPanel;
import slimeknights.tconstruct.tools.client.module.GuiSideInventory;
import slimeknights.tconstruct.tools.inventory.ContainerPartBuilder;
import slimeknights.tconstruct.tools.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.inventory.ContainerSideInventory;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.tileentity.TilePartChest;

@SideOnly(Side.CLIENT)
public class GuiPartBuilder extends GuiTinkerStation {

  private static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/partbuilder.png");

  public static final int Column_Count = 4;

  protected GuiButtonsPartCrafter buttons;
  protected GuiInfoPanel info;
  protected GuiSideInventory sideInventory;
  protected ContainerPatternChest.DynamicChestInventory chestContainer;

  public GuiPartBuilder(InventoryPlayer playerInv, World world, BlockPos pos, TilePartBuilder tile) {
    super(world, pos, (ContainerTinkerStation) tile.createContainer(playerInv, world, pos));

    if(field_147002_h instanceof ContainerPartBuilder) {
      ContainerPartBuilder container = (ContainerPartBuilder) field_147002_h;

      // has part crafter buttons?
      if(container.isPartCrafter()) {
        buttons = new GuiButtonsPartCrafter(this, container, container.patternChest);
        this.addModule(buttons);
      }
      else {
        // has pattern chest inventory?
        chestContainer = container.getSubContainer(ContainerPatternChest.DynamicChestInventory.class);
        if(chestContainer != null) {
          sideInventory = new GuiSideInventory(this, chestContainer, chestContainer.getSlotCount(), chestContainer.columns);
          this.addModule(sideInventory);
        }
      }

      info = new GuiInfoPanel(this, container);
      info.field_147000_g = this.field_147000_g;
      this.addModule(info);
    }
  }

  @Override
  public void func_146977_a(Slot slotIn) {
    if(field_147002_h instanceof ContainerPartBuilder) {
      ContainerPartBuilder container = (ContainerPartBuilder) field_147002_h;
      if(container.isPartCrafter() && slotIn.field_75224_c == container.patternChest)
        return;
    }

    super.func_146977_a(slotIn);
  }

  @Override
  public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
    if(field_147002_h instanceof ContainerPartBuilder) {
      ContainerPartBuilder container = (ContainerPartBuilder) field_147002_h;
      if(container.isPartCrafter() && slotIn.field_75224_c == container.patternChest)
        return false;
    }
    return super.func_146981_a(slotIn, mouseX, mouseY);
  }

  @Override
  protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    drawBackground(BACKGROUND);

    if(sideInventory != null) {
      sideInventory.updateSlotCount(chestContainer.getSizeInventory());
    }

    // draw slot icons
    drawIconEmpty(container.func_75139_a(1), ICON_Shard);
    drawIconEmpty(container.func_75139_a(2), ICON_Pattern);
    drawIconEmpty(container.func_75139_a(3), ICON_Ingot);
    drawIconEmpty(container.func_75139_a(4), ICON_Block);

    super.func_146976_a(partialTicks, mouseX, mouseY);
  }

  @Override
  public void updateDisplay() {
    // check if we have an output
    ItemStack output = container.func_75139_a(0).func_75211_c();
    if(output != null) {
      if(output.func_77973_b() instanceof ToolPart) {
        ToolPart toolPart = (ToolPart) output.func_77973_b();
        Material material = toolPart.getMaterial(output);
        // Material for the toolpart does not make sense, can't build anything out of it!
        if(!toolPart.canUseMaterial(material)) {
          String materialName = material.getLocalizedNameColored() + EnumChatFormatting.WHITE;
          String error = StatCollector.func_74837_a("gui.error.useless_tool_part", materialName, (new ItemStack(toolPart)).func_82833_r());
          warning(error);
        }
        // Material is OK, display material properties
        else {
          setDisplayForMaterial(material);
        }
      }
    }
    // no output, check input
    else {
      // is our input a material item?
      Material material = getMaterial(container.func_75139_a(3).func_75211_c(), container.func_75139_a(4).func_75211_c());
      if(material != null) {
        setDisplayForMaterial(material);
      }
      // no, display general usage information
      else {
        info.setCaption(container.getInventoryDisplayName().func_150254_d());
        info.setText(StatCollector.func_74838_a("gui.partbuilder.info"));
      }
    }
  }

  @Override
  public void error(String message) {
    info.setCaption(StatCollector.func_74838_a("gui.error"));
    info.setText(message);
  }

  @Override
  public void warning(String message) {
    info.setCaption(StatCollector.func_74838_a("gui.warning"));
    info.setText(message);
  }

  public void updateButtons() {
    if(buttons != null) {
      // this needs to be done threadsafe, since the buttons may be getting rendered currently
      Minecraft.func_71410_x().func_152344_a(new Runnable() {
        @Override
        public void run() {
          buttons.updatePosition(cornerX, cornerY, realWidth, realHeight);
        }
      });
    }
  }

  protected void setDisplayForMaterial(Material material) {
    info.setCaption(material.getLocalizedNameColored());

    List<String> stats = Lists.newLinkedList();
    List<String> tips = Lists.newArrayList();
    for(IMaterialStats stat : material.getAllStats()) {
      stats.add(EnumChatFormatting.UNDERLINE + stat.getLocalizedName());
      stats.addAll(stat.getLocalizedInfo());
      stats.add(null);
      tips.add(null);
      tips.addAll(stat.getLocalizedDesc());
      tips.add(null);
    }

    // Traits
    for(ITrait trait : material.getAllTraits()) {
      if(!trait.isHidden()) {
        stats.add(material.getTextColor() + trait.getLocalizedName());
        tips.add(material.getTextColor() + trait.getLocalizedDesc());
      }
    }

    if(!stats.isEmpty() && stats.get(stats.size()-1) == null) {
      // last empty line
      stats.remove(stats.size()-1);
      tips.remove(tips.size()-1);
    }

    info.setText(stats, tips);
  }

  protected Material getMaterial(ItemStack... stacks) {
    for(ItemStack stack : stacks) {
      if(stack == null || stack.func_77973_b() == null) {
        continue;
      }
      // material-item?
      if(stack.func_77973_b() instanceof IMaterialItem) {
        return ((IMaterialItem) stack.func_77973_b()).getMaterial(stack);
      }
    }

    // regular item, check if it belongs to a material
    for(Material material : TinkerRegistry.getAllMaterials()) {
      if(material.matches(stacks) != null) {
        return material;
      }
    }

    // no material found
    return null;
  }

  private Material getMaterialItem(ItemStack stack) {

    return null;
  }
}
