package slimeknights.tconstruct.tools.block;

import com.google.common.collect.Sets;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.oredict.OreDictionary;

import java.util.List;
import java.util.Set;

import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.tools.tileentity.TileToolForge;

// This literally only is its own block because it has a different material
public class BlockToolForge extends BlockTable implements ITinkerStationBlock {

  public final Set<String> baseBlocks = Sets.newHashSet(); // oredict list of toolforge blocks

  public BlockToolForge() {
    super(Material.field_151573_f);
    this.func_149647_a(TinkerRegistry.tabGeneral);

    this.func_149672_a(field_149777_j);
    this.func_149752_b(10f);
    this.func_149711_c(2f);

    this.setHarvestLevel("pickaxe", 0);
  }

  @Override
  public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
    player.openGui(TConstruct.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    if(player.field_71070_bA instanceof BaseContainer) {
      ((BaseContainer) player.field_71070_bA).syncOnOpen((EntityPlayerMP) player);
    }
    return true;
  }

  @Override
  public TileEntity func_149915_a(World worldIn, int meta) {
    return new TileToolForge();
  }

  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    // toolforge has custom blocks
    for(String oredict : baseBlocks) {
      // only add the first entry per oredict
      List<ItemStack> ores = OreDictionary.getOres(oredict);
      if(ores.size() > 0) {
        list.add(createItemstack(this, 0, func_149634_a(ores.get(0).func_77973_b()),
                                 ores.get(0).func_77952_i()));
      }
    }
  }

  @Override
  protected BlockState func_180661_e() {
    return new ExtendedBlockState(this, new IProperty[]{}, new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
  }

  @Override
  public int getGuiNumber(IBlockState state) {
    // same as toolstation
    return 25;
  }
}
