package slimeknights.tconstruct.shared.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;

public class BlockMetal extends EnumBlock<BlockMetal.MetalTypes> {

  public static final PropertyEnum<MetalTypes> TYPE = PropertyEnum.func_177709_a("type", MetalTypes.class);

  public BlockMetal() {
    super(Material.field_151573_f, TYPE, MetalTypes.class);

    func_149711_c(5f);
    setHarvestLevel("pickaxe", -1); // we're generous. no harvest level required
    func_149647_a(TinkerRegistry.tabGeneral);
  }

  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(MetalTypes type : MetalTypes.values()) {
      if(type == MetalTypes.ALUBRASS && !FluidRegistry.isFluidRegistered(TinkerFluids.alubrass)) {
        continue;
      }
      list.add(new ItemStack(this, 1, type.getMeta()));
    }
  }

  public enum MetalTypes implements IStringSerializable, EnumBlock.IEnumMeta {
    COBALT,
    ARDITE,
    MANYULLYN,
    KNIGHTSLIME,
    PIGIRON,
    ALUBRASS,
    SILKY_JEWEL;

    public final int meta;

    MetalTypes() {
      meta = ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }

    @Override
    public int getMeta() {
      return meta;
    }
  }
}
